% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappings.R
\name{MappingsResource}
\alias{MappingsResource}
\title{Mappings Resource}
\value{
Mappings with summary.

Mapping results with summary.
}
\description{
R6 class providing access to mapping operations.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MappingsResource-new}{\code{MappingsResource$new()}}
\item \href{#method-MappingsResource-get}{\code{MappingsResource$get()}}
\item \href{#method-MappingsResource-map}{\code{MappingsResource$map()}}
\item \href{#method-MappingsResource-print}{\code{MappingsResource$print()}}
\item \href{#method-MappingsResource-clone}{\code{MappingsResource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MappingsResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-MappingsResource-new}{}}}
\subsection{Method \code{new()}}{
Create a new MappingsResource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MappingsResource$new(base_req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_req}}{Base httr2 request object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MappingsResource-get"></a>}}
\if{latex}{\out{\hypertarget{method-MappingsResource-get}{}}}
\subsection{Method \code{get()}}{
Get mappings for a concept.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MappingsResource$get(
  concept_id,
  target_vocabularies = NULL,
  mapping_types = NULL,
  direction = "both",
  include_indirect = FALSE,
  standard_only = FALSE,
  include_mapping_quality = FALSE,
  include_synonyms = FALSE,
  include_context = FALSE,
  active_only = TRUE,
  sort_by = NULL,
  sort_order = NULL,
  page = 1,
  page_size = 50
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{The concept ID.}

\item{\code{target_vocabularies}}{Filter by target vocabularies.}

\item{\code{mapping_types}}{Filter by mapping types.}

\item{\code{direction}}{Mapping direction ("outgoing", "incoming", "both"). Default "both".}

\item{\code{include_indirect}}{Include indirect mappings. Default \code{FALSE}.}

\item{\code{standard_only}}{Only standard concept mappings. Default \code{FALSE}.}

\item{\code{include_mapping_quality}}{Include quality metrics. Default \code{FALSE}.}

\item{\code{include_synonyms}}{Include synonyms. Default \code{FALSE}.}

\item{\code{include_context}}{Include mapping context. Default \code{FALSE}.}

\item{\code{active_only}}{Only active mappings. Default \code{TRUE}.}

\item{\code{sort_by}}{Sort field.}

\item{\code{sort_order}}{Sort order.}

\item{\code{page}}{Page number. Default 1.}

\item{\code{page_size}}{Results per page. Default 50.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MappingsResource-map"></a>}}
\if{latex}{\out{\hypertarget{method-MappingsResource-map}{}}}
\subsection{Method \code{map()}}{
Map concepts to a target vocabulary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MappingsResource$map(
  source_concepts,
  target_vocabulary,
  mapping_type = NULL,
  include_invalid = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source_concepts}}{Vector of OMOP concept IDs to map.}

\item{\code{target_vocabulary}}{Target vocabulary ID (e.g., "ICD10CM", "SNOMED").}

\item{\code{mapping_type}}{Mapping type (direct, equivalent, broader, narrower).}

\item{\code{include_invalid}}{Include invalid mappings. Default \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MappingsResource-print"></a>}}
\if{latex}{\out{\hypertarget{method-MappingsResource-print}{}}}
\subsection{Method \code{print()}}{
Print resource information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MappingsResource$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MappingsResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MappingsResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MappingsResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
