% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_helpers.R
\name{normalize}
\alias{normalize}
\title{Normalize function}
\usage{
normalize(data)
}
\arguments{
\item{data}{A data frame containing the sample data. The first column
should contain the sample identifiers, and the rest of the columns
contain the peaks to be normalized. QC samples should be indicated
in the sample identifiers with 'QC'.}
}
\value{
A data frame with the first column as the sample identifiers and
the rest of the columns containing the normalized peak intensities.
}
\description{
This function performs normalization on the input data matrix using
the loess regression method. Normalization is done based on Quality Control
(QC) samples in the data.
}
\examples{

# Load the CSV data
data_file <- system.file("extdata", "example2.csv", package = "omicsTools")
data <- readr::read_csv(data_file)
# Apply the normalize function
normalized_data <- omicsTools::normalize(data)

\donttest{
# Write the normalized data to a new CSV file
readr::write_csv(normalized_data, paste0(tempdir(), "/normalized_data.csv"))
}
}
\author{
Yaoxiang Li \email{yl814@georgetown.edu}

Georgetown University, USA

License: GPL (>= 3)
}
