% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_track_intersection.R
\name{cross_track_intersection}
\alias{cross_track_intersection}
\title{Calculate cross-track intersection}
\usage{
cross_track_intersection(b, a1, a2)
}
\arguments{
\item{b}{coordinates of the body, b:
a vector of longitude, latitude (in decimal degrees) and altitude (in meters) in WGS84}

\item{a1}{first coordinate of a great circle arc:
a vector of longitude, latitude (in decimal degrees) and elevation (in meters) in WGS84}

\item{a2}{second coordinate of a great circle arc:
a vector of longitude, latitude (in decimal degrees) and elevation (in meters) in WGS84}
}
\value{
a WGS84 vector with longitude and latitude (decimal degrees)
}
\description{
Calculate the cross-track intersection between the position of a body (i.e. an aircraft) and
a great circle arc as defined by two points (i.e. the runway's thresholds).
}
\details{
The cross-track intersection between the position of a body, B, (i.e. an aircraft) and
a great circle arc as defined by two points, A1 and A2, (i.e. the runway's thresholds)
is the intersection, X, of the above arc with the great circle arc passing through
the ground projection of B, G, and perpendicular to A1-A2.

\if{html}{\figure{cross-track.svg}{options: width="80\%" alt="cross-track intersection"}}
\if{latex}{\figure{cross-track.png}{options: width=5cm}}
}
\examples{
\dontrun{
# aircraft (longitude, latitude, altitude)
b <- c(8.086135, 49.973942, 6401)
# EDDF: 07R (longitude, latitude, altitude)
a1 <- c(8.53417, 50.0275, 328)
# EDDF: 25L
a2 <- c(8.58653, 50.0401, 362)
cross_track_intersection(b, a1, a2)
}
}
\seealso{
Other utilities: 
\code{\link{along_track_distance}()},
\code{\link{altitude_azimuth_distance}()},
\code{\link{cross_track_distance}()}
}
\concept{utilities}
