% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/values.R
\name{values}
\alias{values}
\title{Extract values from predicate names}
\usage{
values(x)
}
\arguments{
\item{x}{A character vector of predicate names.}
}
\value{
A character vector containing the \verb{<value>} parts of predicate
names in \code{x}. Elements without an equal sign return an empty string.
If \code{x} is \code{NULL}, the function returns \code{NULL}. If \code{x} is an empty
vector (\code{character(0)}), the function returns an empty vector
(\code{character(0)}).
}
\description{
This function extracts the value part from a character vector of predicate
names. Each element of \code{x} is expected to follow the pattern
\verb{<varname>=<value>}, where \verb{<varname>} is a variable name and \verb{<value>} is
the associated value.

If an element does not contain an equal sign (\code{=}), the function returns an
empty string for that element.
}
\details{
This function is the counterpart to \code{\link[=var_names]{var_names()}}, which extracts the
variable part of predicates. Together, \code{\link[=var_names]{var_names()}} and \code{values()} provide
a convenient way to split predicate strings into their variable and value
components.
}
\examples{
values(c("a=1", "a=2", "b=x", "b=y"))
# returns c("1", "2", "x", "y")

values(c("a", "b=3"))
# returns c("", "3")

}
\seealso{
\code{\link[=var_names]{var_names()}}
}
\author{
Michal Burda
}
