% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi.R
\name{spherical_roi}
\alias{spherical_roi}
\title{Create a Spherical Region of Interest}
\usage{
spherical_roi(
  bvol,
  centroid,
  radius,
  fill = NULL,
  nonzero = FALSE,
  use_cpp = TRUE
)
}
\arguments{
\item{bvol}{an \code{NeuroVol} or \code{NeuroSpace} instance}

\item{centroid}{the center of the sphere in positive-coordinate (i,j,k) voxel space.}

\item{radius}{the radius in real units (e.g. millimeters) of the spherical ROI}

\item{fill}{optional value(s) to store as data}

\item{nonzero}{if \code{TRUE}, keep only nonzero elements from \code{bvol}}

\item{use_cpp}{whether to use compiled c++ code}
}
\value{
an instance of class \code{ROIVol}
}
\description{
Creates a Spherical ROI based on a centroid.
}
\examples{
 sp1 <- NeuroSpace(c(10,10,10), c(1,2,3))
 # create an ROI centered around the integer-valued positive voxel coordinate: i=5, j=5, k=5
 cube <- spherical_roi(sp1, c(5,5,5), 3.5)
 vox <- coords(cube)
 cds <- coords(cube, real=TRUE)
 ## fill in ROI with value of 6
 cube1 <- spherical_roi(sp1, c(5,5,5), 3.5, fill=6)
 all(cube1 == 6)

 # create an ROI centered around the real-valued coordinates: x=5, y=5, z=5
 vox <- coord_to_grid(sp1, c(5, 5, 5))
 cube <- spherical_roi(sp1, vox, 3.5)
}
