% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_io.R
\name{close,BinaryReader-method}
\alias{close,BinaryReader-method}
\alias{close,BinaryWriter-method}
\title{Close a BinaryReader or BinaryWriter}
\usage{
\S4method{close}{BinaryReader}(con)

\S4method{close}{BinaryWriter}(con)
}
\arguments{
\item{con}{The BinaryReader or BinaryWriter object to close.}
}
\value{
Invisibly returns \code{NULL}, called for its side effect of closing the connection.
}
\description{
Closes the underlying connection associated with a BinaryReader or BinaryWriter object.
This should be called when you're done with the reader/writer to free system resources.
}
\examples{
\donttest{
# Create a temporary file and write some data
tmp <- tempfile()
writer <- BinaryWriter(tmp, byte_offset = 0L,
                      data_type = "DOUBLE", bytes_per_element = 8L)
write_elements(writer, rnorm(100))
close(writer)

# Read the data back
reader <- BinaryReader(tmp, byte_offset = 0L,
                      data_type = "DOUBLE", bytes_per_element = 8L)
data <- read_elements(reader, 100)
close(reader)

# Clean up
unlink(tmp)
}

}
