% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R, R/neurohypervec.R
\docType{class}
\name{NeuroHyperVec-class}
\alias{NeuroHyperVec-class}
\alias{[,NeuroHyperVec,ANY,ANY,ANY-method}
\alias{[.NeuroHyperVec}
\title{NeuroHyperVec Class}
\usage{
\S4method{[}{NeuroHyperVec,ANY,ANY,ANY}(x, i, j, k, l, m, ..., drop = TRUE)
}
\arguments{
\item{x}{The NeuroHyperVec object}

\item{i, j, k, l, m}{Indices for each dimension}

\item{...}{Additional arguments (not used)}

\item{drop}{Whether to drop dimensions of length 1}
}
\description{
A class representing a five-dimensional brain image, where the first three dimensions are spatial,
the fourth dimension is typically time or trials, and the fifth dimension represents features within a trial.

The \code{NeuroHyperVec} class provides an efficient container for five-dimensional
neuroimaging data where spatial dimensions are sparse. It is particularly suited for
analyses involving multiple features per trial/timepoint, such as basis functions,
spectral components, or multi-modal measurements.
}
\details{
Five-Dimensional Sparse Neuroimaging Data Container


The class organizes data in a 5D structure:
\itemize{
  \item Dimensions 1-3: Spatial coordinates (x, y, z)
  \item Dimension 4: Trials or timepoints
  \item Dimension 5: Features or measurements
}

Data is stored internally as a three-dimensional array for efficiency:
\itemize{
  \item Dimensions 1: Features (dimension 5)
  \item Dimensions 2: Trials (dimension 4)
  \item Dimensions 3: Voxels (flattened spatial)
}

Key features:
\itemize{
  \item Memory-efficient sparse storage of spatial dimensions
  \item Fast access to feature vectors and time series
  \item Flexible indexing across all dimensions
  \item Maintains spatial relationships and metadata
}
}
\section{Slots}{

\describe{
\item{\code{mask}}{An object of class \code{\linkS4class{LogicalNeuroVol}} defining the sparse spatial domain of the brain image.}

\item{\code{data}}{A 3D array with dimensions [features x trials x voxels] containing the neuroimaging data.}

\item{\code{space}}{A \code{\linkS4class{NeuroSpace}} object representing the dimensions and voxel spacing of the neuroimaging data.}

\item{\code{lookup_map}}{An integer vector for O(1) spatial index lookups.}

\item{\code{mask}}{A \code{\linkS4class{LogicalNeuroVol}} object defining the spatial mask.}

\item{\code{data}}{A three-dimensional array with dimensions [features x trials x voxels] containing the data.}

\item{\code{space}}{A \code{\linkS4class{NeuroSpace}} object defining the 5D space.}

\item{\code{lookup_map}}{An integer vector for O(1) spatial index lookups.}
}}

\examples{

# Create a simple 5D dataset (10x10x10 spatial, 5 trials, 3 features)
dims <- c(10, 10, 10)
space <- NeuroSpace(c(dims, 5, 3))

# Create a sparse mask (20\% of voxels)
mask_data <- array(runif(prod(dims)) < 0.2, dims)
mask <- LogicalNeuroVol(mask_data, NeuroSpace(dims))

# Generate random data for active voxels
n_voxels <- sum(mask_data)
data <- array(rnorm(3 * 5 * n_voxels), dim = c(3, 5, n_voxels))  # [features x trials x voxels]

# Create NeuroHyperVec object
hvec <- NeuroHyperVec(data, space, mask)

# Access operations
# Get data for specific voxel across all trials/features
series(hvec, 5, 5, 5)

# Extract a 3D volume for specific trial and feature
hvec[,,,2,1]


}
\seealso{
\code{\linkS4class{NeuroVec}}, \code{\linkS4class{LogicalNeuroVol}}, \code{\linkS4class{NeuroSpace}}
}
