% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_info.R
\name{MetaInfo}
\alias{MetaInfo}
\title{Create Neuroimaging Metadata Object}
\usage{
MetaInfo(
  Dim,
  spacing,
  origin = rep(0, length(spacing)),
  data_type = "FLOAT",
  label = "",
  spatial_axes = OrientationList3D$AXIAL_LPI,
  additional_axes = NullAxis
)
}
\arguments{
\item{Dim}{Integer vector. Image dimensions (e.g., c(64, 64, 32) for 3D).}

\item{spacing}{Numeric vector. Voxel dimensions in mm.}

\item{origin}{Numeric vector. Coordinate origin. Default is zero vector.}

\item{data_type}{Character. Data type (e.g., "FLOAT", "SHORT"). Default is "FLOAT".}

\item{label}{Character. Image label(s). Default is "".}

\item{spatial_axes}{Object. Spatial orientation. Default is OrientationList3D$AXIAL_LPI.}

\item{additional_axes}{Object. Non-spatial axes. Default is NullAxis.}
}
\value{
A MetaInfo object
}
\description{
Creates a MetaInfo object containing essential metadata for neuroimaging data,
  including dimensions, spacing, orientation, and data type information.
}
\details{
Create MetaInfo Object


The MetaInfo object is fundamental for:
\itemize{
  \item Spatial interpretation of image data
  \item Data type handling and conversion
  \item Memory allocation and mapping
  \item File I/O operations
}

Input validation ensures:
\itemize{
  \item Dimensions are positive integers
  \item Spacing values are positive
  \item Origin coordinates are finite
  \item Data type is supported
}
}
\examples{
# Create metadata for 3D structural MRI
meta <- MetaInfo(
  Dim = c(256, 256, 180),
  spacing = c(1, 1, 1),
  data_type = "FLOAT",
  label = "T1w"
)

# Get image dimensions
dim(meta)

# Get transformation matrix
trans(meta)

}
\seealso{
\code{\linkS4class{NIFTIMetaInfo}}, \code{\linkS4class{AFNIMetaInfo}}
}
