% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.NeuralGAM.R
\name{summary.neuralGAM}
\alias{summary.neuralGAM}
\title{Summary of a \code{neuralGAM} model}
\usage{
\method{summary}{neuralGAM}(object, ...)
}
\arguments{
\item{object}{A \code{neuralGAM} object.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns \code{object}. Prints a human-readable summary.
}
\description{
Summarizes a fitted \code{neuralGAM} object: family, formula, sample size,
intercept, training MSE, per-term neural net settings, per-term NN layer
configuration, and training history. If a linear component is present, its
coefficients are also reported.
}
\examples{
\dontrun{

library(neuralGAM)
dat <- sim_neuralGAM_data()
train <- dat$train
test  <- dat$test

ngam <- neuralGAM(
  y ~ s(x1) + x2 + s(x3),
  data = train,
  num_units = 128,
  family = "gaussian",
  activation = "relu",
  learning_rate = 0.001,
  bf_threshold = 0.001,
  max_iter_backfitting = 10,
  max_iter_ls = 10,
  seed = 1234
)
summary(ngam)
}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo
}
