% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.netdose.R
\name{predict.netdose}
\alias{predict.netdose}
\title{Predicted values for dose-response network meta-analysis}
\usage{
\method{predict}{netdose}(object, agent1 = NULL, dose1 = NULL, agent2 = NULL, dose2 = NULL, ...)
}
\arguments{
\item{object}{An object of class netdose (mandatory).}

\item{agent1}{An optional character string specifying the first agent
to be used for the prediction. By default, all agents are used.}

\item{dose1}{An optional numeric vector specifying custom doses for the
prediction. By default, the doses are set to the common observed doses as defined in the data.}

\item{agent2}{An optional character string specifying the second agent
to be used for the prediction. By default, the reference agent is used.}

\item{dose2}{An optional numeric vector specifying the dose for the second
agent. By default the common dose of the second agent is used.}

\item{...}{Additional arguments (ignored).}
}
\value{
A data frame with additional class \code{predict.netdose} containing the
following variables:
\item{agent1, dose1, agent2, dose2}{As defined above}
\item{pred}{A numeric vector with the predicted effects}
\item{se.pred}{A numeric vector with standard errors of the predicted effects}
\item{lower}{A numeric vector specifying the lower bounds of the predicted values}
\item{upper}{A numeric vector specifying the upper bounds of the predicted values}
}
\description{
This function provides the predicted values based on the results of dose-response
network meta-analysis.
}
\details{
The predict.netdose function calculates predicted effects for specified doses of one or more
agents, based on a dose-response network meta-analysis.
It supports both linear and non-linear dose-response relationships, accommodating various
modeling methods including linear, exponential, fractional polynomials, restricted cubic splines (RCS),
and quadratic relationships.
This function is particularly useful for exploring comparative effectiveness
at specific dose levels of the agents, facilitating the interpretation of
complex dose-response relationships in a network meta-analysis setting.
By allowing predictions for multiple combinations of agents and doses,
it offers flexibility in evaluating hypothetical scenarios or estimating effects
for doses outside the directly observed range (where extrapolation is appropriate).
}
\examples{
# Load anesthesia data
data(anesthesia)

# Use a subset of 5 studies
anesthesia_subset <- subset(anesthesia, study \%in\% unique(anesthesia$study)[1:5])

# Prepare data for DR-NMA
dat <- meta::pairwise(
  agent = list(agent1, agent2, agent3),
  event = list(event1, event2, event3),
  n = list(n1, n2, n3),
  dose = list(dose1, dose2, dose3),
  data = anesthesia_subset,
  studlab = study,
  append = FALSE,
  sm = "RR"
)


# Perform DR-NMA with a linear dose-response function
dr1 <- netdose(
  TE, seTE, agent1, dose1, agent2,
  dose2, studlab,
  data = dat
)

# Predicted values
pred1 <- predict(dr1)

}
\references{
Petropoulou et al. (2025):
Network meta-analysis with dose-response relationships.
}
\author{
Maria Petropoulou <maria.petropoulou@uniklinik-freiburg.de>,
  Guido Schwarzer <guido.schwarzer@uniklinik-freiburg.de>
}
