% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetData.R
\name{subsetData}
\alias{subsetData}
\title{Subset of the result table}
\usage{
subsetData(x, cutoff = c(0.2, 0.5, 0.8))
}
\arguments{
\item{x}{An object of class "netSEM", the returned list from \code{netSEMm}. Plotting uses the first element of this list (res.print) in which the first column of it is endogenous variable, second column is variable and other columns are corresponding best functional form, r-squared, adj-r-squared, P-value1, P-value2 and P-value3.}

\item{cutoff}{A threshold value for adjusted R-squared. The maximum number of cutoff is 3.}
}
\value{
The dataframe of different subset of the result table.
}
\description{
This function creat different Subset of the result table based on the cutoffs.
}
\examples{
# Load acrylic data set
data(acrylic)
# Build a semi-gSEM model
ans <- netSEMm(acrylic)
# Subset dataset with different cutoff
res <- subsetData(ans,cutoff=c(0.2))
res <- subsetData(ans,cutoff=c(0.2,0.5))
res <- subsetData(ans,cutoff=c(0.2,0.5,0.8))

}
