% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gatai_convergence_plots.R
\name{convergence_plots}
\alias{convergence_plots}
\title{Create Convergence Plots for GATAI Analysis}
\usage{
convergence_plots(phyex_set, runs, ps = c(0.5))
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{runs}{List of GATAI run results}

\item{ps}{Vector of consensus thresholds to analyze (default: c(0.5))}
}
\value{
A list with two ggplot objects:
\describe{
  \item{counts}{Plot showing convergence of consensus set sizes}
  \item{pval}{Plot showing convergence of p-values}
}
}
\description{
Create plots showing how consensus gene set sizes and p-values
converge across GATAI runs for different threshold values.
}
\details{
This function analyzes how consensus gene sets and their statistical
significance change as more GATAI runs are included in the analysis.
It uses cached null distributions for efficient p-value calculation.
# Create convergence plots
# conv_plots <- convergence_plots(phyex_set, gatai_runs, ps = c(0.25, 0.5, 0.75))
}
\keyword{internal}
