% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlsig.R
\name{vlsig}
\alias{vlsig}
\title{Elementary voice leadings}
\usage{
vlsig(set, index = 1, display_digits = 2, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{index}{Integer: which voice-leading generator should be displayed? Defaults to \code{1},
the one which induces the least amount of motion.}

\item{display_digits}{Integer: how many digits to display when naming any
non-integral interval sizes. Defaults to 2.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
List with three elements:
\itemize{
\item "vl" which shows the distance (in \code{edo} steps) that each voice moves
\item "tn" which indicates the (chromatic) transposition achieved by the voice leading
\item "rotation" which indicates the scalar transposition caused by the voice leading
}
}
\description{
Calculates the "\strong{v}oice-\strong{l}eading \strong{sig}nature" of the set's elementary transpositions
as determined by \code{\link[=vl_generators]{vl_generators()}}.
}
\details{
Note that the voice leadings determined by \code{vlsig()} can be different from the
corresponding ones at the same \eqn{T_n} level in \code{\link[=vl_rolodex]{vl_rolodex()}}. The latter function
prioritizes minimal voice leadings, whereas \code{vlsig()} prioritizes \emph{elementary} voice
leadings derived from a set's \code{\link[=brightnessgraph]{brightnessgraph()}}. In particular, this means that
\code{vlsig()} voice leadings will always be ascending, involve at least one common tone,
and involve no contrary motion. See the \code{odd_pentachord} voice leadings in the Examples.
}
\examples{
major_scale <- c(0, 2, 4, 5, 7, 9, 11)
vlsig(major_scale) # Hook's elementary signature transformation

pure_major_triad <- j(1, 3, 5)
vlsig(pure_major_triad, index=1)
vlsig(pure_major_triad, index=2)

odd_pentachord <- c(0, 1, 4, 9, 11) # in 15-edo
vlsig(odd_pentachord, index=2, edo=15)
vl_rolodex(odd_pentachord, edo=15)$"8" 

}
