% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traitData.plot.R
\name{traitData.plot}
\alias{traitData.plot}
\title{plot a univariate continuous trait data on a phylogeny}
\usage{
traitData.plot(
  y,
  phy,
  col.label = "red",
  col.tree = "black",
  col.hist = "navy",
  cex.plot = 0.7,
  cex.tips = 0.7,
  show.tips = FALSE,
  include.hist = FALSE,
  n.split = 5,
  lwd.traits = 1,
  show.axis = TRUE,
  axis.text = NULL,
  transform.axis.label = NULL,
  at = NULL,
  labels = NULL,
  axis.text.line = 1,
  offset.bars = 1,
  ...
)
}
\arguments{
\item{y}{A matrix of trait values with taxon names as rownames.}

\item{phy}{An object of class \code{phylo} (see \pkg{ape}).}

\item{col.label}{colour labels for the traits at the tips and in the histogram}

\item{col.tree}{colour for the edge labels on the tree}

\item{col.hist}{colour of the histogram}

\item{cex.plot}{Numeric. The size of labels for the histogram axis labels}

\item{cex.tips}{Numeric. The size of the phylogeny tip labels}

\item{show.tips}{Logical. If FALSE (default), no tip labels are shown. If TRUE, tip labels are shown}

\item{include.hist}{Logical. Include a histrogram alongside the plot of the tree?}

\item{n.split}{Numeric. The number of splits for the axis labels and shading for the trait values}

\item{lwd.traits}{Line widths of traits shown on the plot}

\item{show.axis}{Logical. If TRUE, shows the axis of trait values on the plot.}

\item{axis.text}{text shown above the trait label axis. If NULL (default), nothing is displayed}

\item{transform.axis.label}{If the data are provided as logarithms the labels for trait axis can be transformed to their original values by calculating the exponential function of the natural (transform.axis.label="exp") or base 10 logarithm. The default (NULL) leaves the labels un-transformed.}

\item{at}{Axis tick point locations for if show.axis is TRUE.}

\item{labels}{Axis labels locations for if show.axis is TRUE.}

\item{axis.text.line}{The location of the label for the trait axis beside the plot.}

\item{offset.bars}{The distance of trait plot lines from the phylogeny.}

\item{...}{further arguments passed to the axis function}
}
\value{
A plot with the trait values shown at the tips, and a histrogram of the trait values
}
\description{
Plots a phylogeny with lines representing the value of a continuous trait
}
\examples{
data(anolis.tree)
data(anolis.data)
attach(anolis.data)
male.length <- matrix(Male_SVL, dimnames=list(rownames(anolis.data)))
sortedData <- sortTraitData(anolis.tree, male.length)
phy <- sortedData$phy
male.length <- sortedData$trait
traitData.plot(y=male.length, phy)
}
\author{
Mark Puttick
}
