% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpFDAScaleRange.R
\name{mlr_pipeops_fda.scalerange}
\alias{mlr_pipeops_fda.scalerange}
\alias{PipeOpFDAScaleRange}
\title{Linearly Transform the Domain of Functional Data.}
\description{
Linearly transform the domain of functional data so they are between \code{lower} and \code{upper}.
The formula for this is \eqn{x' = offset + x * scale},
where \eqn{scale} is \eqn{(upper - lower) / (max(x) - min(x))} and
\eqn{offset} is \eqn{-min(x) * scale + lower}. The same transformation is applied during training and prediction.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link[mlr3pipelines:PipeOpTaskPreproc]{PipeOpTaskPreproc}},
as well as the following parameters:
\itemize{
\item \code{lower} :: \code{numeric(1)} \cr
Target value of smallest item of input data. Initialized to \code{0}.
\item \code{uppper} :: \code{numeric(1)} \cr
Target value of greatest item of input data. Initialized to \code{1}.
}
}

\examples{
task = tsk("fuel")
po_scale = po("fda.scalerange", lower = -1, upper = 1)
task_scale = po_scale$train(list(task))[[1L]]
task_scale$data()
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{PipeOpFDAScaleRange}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpFDAScaleRange-new}{\code{PipeOpFDAScaleRange$new()}}
\item \href{#method-PipeOpFDAScaleRange-clone}{\code{PipeOpFDAScaleRange$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDAScaleRange-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDAScaleRange-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new instance of this Class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDAScaleRange$new(id = "fda.scalerange", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of resulting object, default \code{"fda.scalerange"}.}

\item{\code{param_vals}}{(named \code{list})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction. Default \code{list()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDAScaleRange-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDAScaleRange-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDAScaleRange$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
