% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packing.R
\name{mknapsack}
\alias{mknapsack}
\title{Optimal packing into multiple containers}
\usage{
mknapsack(profit, volume, moq = rep(0, length(profit)), cap = 65,
  sold = rep(0, length(profit)))
}
\arguments{
\item{profit}{vector with profit for item}

\item{volume}{vector of item sizes in cubic meters}

\item{moq}{vector of flags where 1 means that row contans mininum order quantity (MOQ).
Defaults to zero vector matching profit in length.}

\item{cap}{size of the container in cubic meters}

\item{sold}{vector with a number of items that were sold on demand}
}
\value{
vector with container numbers keeping the permutation of the original data
}
\description{
Gets containers based on the utility of individual items, their volume and container size
}
\examples{

# Calculate the optimal containers summary for a sample dataset
data(unitsbro)
library(data.table)
units.combined <- data.table(unitsbro)
moq <- units.combined$moq
profit <- units.combined$utility
volume <- units.combined$volume
res <- mknapsack(profit, volume, moq, 65)
units.combined$container <- as.factor(res)
#Aggregate solution to container
containers <- units.combined[order(container), .(volume = sum(volume),
profit = sum(profit)), by = container]

}
