% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{gdataset.load}
\alias{gdataset.load}
\title{Load a dataset into the namespace}
\usage{
gdataset.load(path, force = FALSE, verbose = FALSE)
}
\arguments{
\item{path}{Path to a dataset or misha database directory}

\item{force}{If TRUE, ignore name collisions (working db wins; for dataset-to-dataset, later-loaded wins)}

\item{verbose}{If TRUE, print loaded track/interval names and summary counts}
}
\value{
Invisibly returns a list with:
  \item{tracks}{Number of visible tracks loaded}
  \item{intervals}{Number of visible intervals loaded}
  \item{shadowed_tracks}{Number of tracks shadowed by collisions}
  \item{shadowed_intervals}{Number of intervals shadowed by collisions}
}
\description{
Loads tracks and intervals from a dataset directory, making them available
for analysis alongside the working database.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

dataset_path <- gdataset.example_path()
gdataset.load(dataset_path)
gdataset.unload(dataset_path)

}
\seealso{
\code{\link{gdataset.unload}}, \code{\link{gdataset.save}}, \code{\link{gdataset.ls}}
}
