% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screeplot_svd.R
\name{screeplot_svd}
\alias{screeplot_svd}
\title{Scree plot for singular values.}
\usage{
screeplot_svd(data, link = "logit", epsilon = 1e-04, K_max = 10)
}
\arguments{
\item{data}{the data matrix. Entries are either binary or categorical.
Missing entries should be \code{NA}.}

\item{link}{the link function. Possible choices are "logit" and "probit".}

\item{epsilon}{the truncation parameter. Default value is 1e-4.}

\item{K_max}{The maximum number of factors contained in data. Default value is 10.}
}
\description{
Scree plot for singular values.
}
\examples{
require(mirtjml)

# load a simulated dataset
attach(data_sim)

data <- data_sim$response
screeplot_svd(data, K_max = 10)

}
\references{
Zhang, H., Chen, Y., & Li, X. (2020). A note on exploratory item factor
analysis by singular value decomposition. Psychometrika, 1-15, \doi{10.1007/s11336-020-09704-7}.
}
