% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_midr.R
\name{theme_midr}
\alias{theme_midr}
\alias{par.midr}
\title{Default Plotting Themes}
\usage{
theme_midr(
  grid_type = c("none", "x", "y", "xy"),
  base_size = 11,
  base_family = "serif",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)

par.midr(...)
}
\arguments{
\item{grid_type}{the type of grid lines to display, one of "none", "x", "y" or "xy".}

\item{base_size}{base font size, given in pts.}

\item{base_family}{base font family.}

\item{base_line_size}{base size for line elements.}

\item{base_rect_size}{base size for rect elements.}

\item{...}{for \code{par.midr()}, optional arguments in \code{tag = value} form to be passed to \code{graphics::par()}.}
}
\value{
\code{theme_midr()} provides a \strong{ggplot2} theme customized for the \strong{midr} package.

\code{par.midr()} returns the previous values of the changed parameters in an invisible named list.
}
\description{
\code{theme_midr()} returns a complete theme for "ggplot" objects, providing a consistent visual style for \strong{ggplot2} plots.

\code{par.midr()} can be used to set graphical parameters for base R graphics.
}
\examples{
# Use theme_midr() with ggplot2
X <- data.frame(x = 1:10, y = 1:10)
ggplot2::ggplot(X) +
  ggplot2::geom_point(ggplot2::aes(x, y)) +
  theme_midr()
ggplot2::ggplot(X) +
  ggplot2::geom_col(ggplot2::aes(x, y)) +
  theme_midr(grid_type = "y")
ggplot2::ggplot(X) +
  ggplot2::geom_line(ggplot2::aes(x, y)) +
  theme_midr(grid_type = "xy")

# Use par.midr() for base R graphics
old.par <- par.midr()
plot(y ~ x, data = X)
par(old.par)
}
