% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_mid.R
\name{predict.mid}
\alias{predict.mid}
\title{Predict Method for fitted MID Models}
\usage{
\method{predict}{mid}(
  object,
  newdata = NULL,
  na.action = "na.pass",
  type = c("response", "link", "terms"),
  terms = object$terms,
  ...
)
}
\arguments{
\item{object}{a "mid" object to be used to make predictions.}

\item{newdata}{a data frame of the new observations. If \code{NULL}, the original fitted values are extracted and returned.}

\item{na.action}{a function or character string specifying what should happen when the data contain \code{NA} values.}

\item{type}{the type of prediction required. One of "response", "link", or "terms".}

\item{terms}{a character vector of term labels, specifying a subset of component functions to use for predictions.}

\item{...}{arguments to be passed to other methods (not used in this method).}
}
\value{
\code{predict.mid()} returns a numeric vector of MID model predictions, or a matrix if \code{type = "terms"}.
}
\description{
\code{predict.mid()} is an S3 method for "mid" objects that obtains predictions from a fitted MID model.
It can be used to predict on new data or to retrieve the fitted values from the original data.
}
\details{
The \code{type} argument allows you to specify the scale of the prediction.
By default (\code{type = "response"}), the function returns predictions on the original scale of the response variable.
Alternatively, you can obtain predictions on the scale of the linear predictor by setting \code{type = "link"}.
For a detailed breakdown, setting \code{type = "terms"} returns a matrix where each column represents the contribution of a specific model term on the linear predictor scale.

The \code{terms} argument allows for predictions based on a subset of the model's component functions, excluding others.
}
\examples{
data(airquality, package = "datasets")
test <- 1:10
mid <- interpret(Ozone ~ .^2, airquality[-test, ], lambda = 1, link = "log")

# Predict on new data
predict(mid, airquality[test, ])

# Get predictions on the link scale
predict(mid, airquality[test, ], type = "link")

# Get the contributions of specific terms
predict(mid, airquality[test, ], terms = c("Temp", "Wind"), type = "terms")
}
\seealso{
\code{\link{interpret}}, \code{\link{mid.effect}}, \code{\link{get.yhat}}
}
