% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractMemoryFeatures.R
\name{extractMemoryFeatures}
\alias{extractMemoryFeatures}
\title{Extracts ecological memory features on the output of \code{\link{computeMemory}}.}
\usage{
extractMemoryFeatures(
 memory.pattern = NULL,
 exogenous.component = NULL,
 endogenous.component = NULL,
 sampling.subset = NULL,
 scale.strength = TRUE
 )
}
\arguments{
\item{memory.pattern}{either a list resulting from \code{\link{computeMemory}}, or a dataframe with memory patterns of several taxa generated by \code{\link{experimentToTable}}.}

\item{exogenous.component}{character string or vector of character strings, name of the variable or variables defining the exogenous component.}

\item{endogenous.component}{character string, string, name of the variable defining the endogenous component. If the data was generated by \code{\link{prepareLaggedData}}, \code{endogenous.component} would usually be \code{"Response"}.}

\item{sampling.subset}{only relevant when \code{analysis.output} is the result of \code{runExperiment}. Character string with the name of the column of the list with the simulation outcomes.}

\item{scale.strength}{boolean. If \code{TRUE}, the strength of the ecological memory components, which has the same units as the importance scores yielded by Random Forest (percentage of increment in mean squared error when a variable is permuted), is scaled between 0 and 1.}
}
\value{
A dataframe with 8 columns and 1 row if \code{memory.pattern} is the output of \code{\link{computeMemory}} and 13 columns and as many rows as taxa are in the input if it is the output of \code{\link{experimentToTable}}. The columns are:

\itemize{
  \item \emph{label} character string to identify the taxon. It either inherits its values from \code{\link{experimentToTable}}, or sets the default ID as "1".
  \item \emph{strength.endogenous} numeric in the range [0, 100], in importance units (percentage of increment in the mean squared error of the random forest model if the variable is permuted) difference between the maximum importance of the endogenous component at any lag and the median of the random component (see details in \code{\link{computeMemory}})
  \item \emph{strength.exogenous} numeric in the range [0, 100], same as above, but for the exogenous component.
  \item \emph{strenght.concurrent} numeric in the range [0, 100], same as above, but for the concurrent component (driver at lag 0).
  \item \emph{length.endogenous} numeric in the range [0, 100], proportion of lags over which the importance of the endogenous memory component is above the median of the random component.
  \item \emph{length.exogenous} numeric in the range [0, 1], same as above but for the exogenous memory component.
  \item \emph{dominance.endogenous} numeric in the range [0, 1], proportion of the lags above the median of the random term over which a the endogenous memory component has a higher importance than the exogenous component.
  \item \emph{dominance.exogenous}, opposite as above.
  \item \emph{maximum.age}, numeric. As every column after this one, only provided if \code{memory.pattern} is the output of \code{\link{experimentToTable}}. Trait of the given taxon.
  \item \emph{fecundity} numeric, trait of the given taxon.
  \item \emph{niche.A.mean} numeric, trait of the given taxon.
  \item \emph{niche.A.sd} numeric, trait of the given taxon.
  \item \emph{sampling} numeric, trait of the given taxon.
}
}
\description{
It computes the following features of the ecological memory patterns returned by \code{\link{computeMemory}}:
\itemize{
   \item \code{memory strength} maximum difference in relative importance between each component (endogenous, exogenous, and concurrent) and the median of the random component. This is computed for exogenous, endogenous, and concurrent effect.
    \item \code{memory length} proportion of lags over which the importance of a memory component is above the median of the random component. This is only computed for endogenous and exogenous memory.
\item \code{dominance} proportion of the lags above the median of the random term over which a memory component has a higher importance than the other component. This is only computed for endogenous and exogenous memory.
}
}
\details{
\strong{Warning:} this function only works when only one exogenous component (driver) is used to define the model in \code{\link{computeMemory}}. If more than one driver is provided throught the argument \code{exogenous.component}, the maximum importance scores of all exogenous variables is considered. In other words, the importance of exogenous variables is not additive.
}
\examples{

#loading example data
data(palaeodataMemory)

#computing ecological memory features
memory.features <- extractMemoryFeatures(
  memory.pattern = palaeodataMemory,
  exogenous.component = c(
  "climate.temperatureAverage",
  "climate.rainfallAverage"
  ),
  endogenous.component = "Response",
  sampling.subset = NULL,
  scale.strength = TRUE
  )


}
\seealso{
\code{\link{computeMemory}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
