% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_match.R
\name{wif_match}
\alias{wif_match}
\title{Match Datasets With Differing Scenarios}
\usage{
wif_match(x, y, by = NULL)
}
\arguments{
\item{x}{First dataset to match}

\item{y}{Second dataset to match}

\item{by}{Grouping variable(s) to match on, defaults to NULL}
}
\value{
List containing matched datasets with aligned scenario IDs:
\itemize{
\item First element: matched version of dataset x
\item Second element: matched version of dataset y
}
}
\description{
Matches datasets by group and preserves baseline scenarios (scenario_id=0) when scenarios differ between them.
}
\examples{
x <- data.frame(
  category = c("a", "b", "a", "b"),
  scenario_id = c(0, 0, 1, 1),
  value = 1:4
)

y <- data.frame(
  category = c("a", "b", "a", "b"),
  scenario_id = c(0, 0, 2, 2),
  value = 5:8
)

# Automatic matching
result <- wif_match(x, y)

}
