% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_genoprob_error.R
\name{calc_genoprob_error}
\alias{calc_genoprob_error}
\title{Compute conditional probabilities of the genotypes using global error}
\usage{
calc_genoprob_error(
  input.map,
  step = 0,
  phase.config = "best",
  error = 0.01,
  th.prob = 0.95,
  restricted = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{input.map}{An object of class \code{mappoly.map}}

\item{step}{Maximum distance (in cM) between positions at which 
the genotype probabilities are calculated, though for 
step = 0, probabilities are calculated only at the 
marker locations.}

\item{phase.config}{which phase configuration should be used. "best" (default) 
will choose the maximum likelihood configuration}

\item{error}{the assumed global error rate (default = 0.01)}

\item{th.prob}{the threshold for using global error or genotype 
probability distribution contained in the dataset (default = 0.95)}

\item{restricted}{if \code{TRUE} (default), restricts the prior to the 
possible classes under Mendelian non double-reduced 
segregation given the parental dosages}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if
\code{FALSE}, no output is produced}
}
\value{
An object of class 'mappoly.genoprob' which has two elements: a tridimensional
array containing the probabilities of all possible genotypes for each individual
in each marker position; and the marker sequence with it's recombination frequencies
}
\description{
Conditional genotype probabilities are calculated for each marker
position and each individual given a map.
}
\examples{
 \donttest{
     probs.error <- calc_genoprob_error(input.map = solcap.err.map[[1]],
                                error = 0.05,
                                verbose = TRUE)
 }

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
