% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lwqs.R
\name{extract_weights}
\alias{extract_weights}
\title{Function to extract time-varying weights from lWQS object}
\usage{
extract_weights(lobj)
}
\arguments{
\item{lobj}{An object returned from lWQS function}
}
\value{
A (long-form) data frame containing the time index and corresponding variable weights estimated in an lWQS
}
\description{
Function to extract time-varying weights from lWQS object
}
\examples{
\donttest{
# identify predictor variables used in mixture
mixvars=names(lwqs_data)[5:9]

# run model
model=lwqs(data=lwqs_data,
           timevar="time",
           wqs_parms=list(formula=out ~ wqs,
              data = lwqs_data,
              mix_name=mixvars,
              b1_constr = TRUE,
              b1_pos=TRUE,
              b = 5,
              q = 5,
              validation = 0,
              family = "gaussian",
              seed = 1),
              outcome="out",
              ID="ID")

# use extract_weights to access time-varying predictor weights
timeweights=extract_weights(model)}
}
