% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.lmdu.R
\name{predict.lmdu}
\alias{predict.lmdu}
\title{The function predict.lmdu makes predictions for a test/validation set
 based on a fitted lrmdu model (lmdu with X)}
\usage{
\method{predict}{lmdu}(object, newX, newY = NULL, ...)
}
\arguments{
\item{object}{An \code{lmdu} object}

\item{newX}{An N by P matrix with predictor variables for a test/validation set}

\item{newY}{An N by R matrix with response variables  for a test/validation set}

\item{\dots}{additional arguments to be passed.}
}
\value{
This function returns an object of the class \code{lpca} with components:
\item{Yhat}{Predicted values for the test set}
\item{devr}{Estimated prediction deviance for separate responses}
\item{devtot}{Estimated prediction deviance for all responses}
\item{Brier.r}{Estimated Brier score for separate responses}
\item{Brier}{Estimated Brier score for all responses}
}
\description{
The function predict.lmdu makes predictions for a test/validation set
 based on a fitted lrmdu model (lmdu with X)
}
\examples{
\dontrun{
data(dataExample_lpca)
Y = as.matrix(dataExample_lmdu[-c(1:20) , 1:8])
X = as.matrix(dataExample_lmdu[-c(1:20) , 9:13])
newY = as.matrix(dataExample_lmdu[1:20 , 1:8])
newX = as.matrix(dataExample_lmdu[1:20 , 9:13])
# supervised
output = lmdu(Y = Y, X = X, S = 2)
preds = predict(output, newX = newX, newY = newY)
}

}
