% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lpca.R
\name{plot.lpca}
\alias{plot.lpca}
\title{Plots a Logistic PCA Model}
\usage{
\method{plot}{lpca}(
  x,
  dims = c(1, 2),
  type = "H",
  ycol = "darkgreen",
  xcol = "lightskyblue",
  ocol = "grey",
  ...
)
}
\arguments{
\item{x}{an object of type lpca}

\item{dims}{which dimensions to visualize}

\item{type}{either H (hybrid), I (inner product/pca), or D (distance/melodic)}

\item{ycol}{colour for representation of response variables}

\item{xcol}{colour for representation of predictor variables}

\item{ocol}{colour for representation of row objects}

\item{\dots}{additional arguments to be passed.}
}
\value{
Plot of the results obtained from lpca
}
\description{
Plots a Logistic PCA Model
}
\examples{
\dontrun{
data(dataExample_lpca)
Y = as.matrix(dataExample_lpca[, 1:8])
X = as.matrix(dataExample_lpca[, 9:13])
# unsupervised
output = lpca(Y = Y, S = 2)
plot(output)
}

}
