% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelselection.R
\name{vrm_import}
\alias{vrm_import}
\title{Import Vital Rate Model Factor Values for Function-based MPM Development}
\usage{
vrm_import(
  years = NULL,
  patches = c(1),
  groups = c(0),
  interactions = FALSE,
  zi = FALSE,
  cat.indcova = NULL,
  cat.indcovb = NULL,
  cat.indcovc = NULL,
  dist.sizea = "gaussian",
  dist.sizeb = "constant",
  dist.sizec = "constant",
  dist.fec = "gaussian",
  trunc.sizea = FALSE,
  trunc.sizeb = FALSE,
  trunc.sizec = FALSE,
  trunc.fec = FALSE,
  use.juv = FALSE
)
}
\arguments{
\item{years}{A numeric vector of the years or times at time \code{t} to be
modeled.}

\item{patches}{A string or numeric vector of the patch names to be modeled.}

\item{groups}{An integer vector of stage groups to be modeled. Defaults to a
vector with a single element with value \code{0}.}

\item{interactions}{A logical value indicating whether to include two-way
interactions between main effects (\code{TRUE}), or only main effects
(\code{FALSE}). Defaults to \code{FALSE}.}

\item{zi}{A logical value indicating whether to include coefficients for the
binomial components of zero-inflation models. Defaults to \code{FALSE}.}

\item{cat.indcova}{If individual covariate a is categorical, then this term
should equal a string vector of the names of the categories. Defaults to
\code{NULL}, in which case individual covariate a is either not used or is
numeric.}

\item{cat.indcovb}{If individual covariate b is categorical, then this term
should equal a string vector of the names of the categories. Defaults to
\code{NULL}, in which case individual covariate b is either not used or is
numeric.}

\item{cat.indcovc}{If individual covariate c is categorical, then this term
should equal a string vector of the names of the categories. Defaults to
\code{NULL}, in which case individual covariate c is either not used or is
numeric.}

\item{dist.sizea}{A string value giving the distribution of the variable
coding primary size. Can equal \code{"none"}, \code{"gamma"},
\code{"gaussian"}, \code{"poisson"}, \code{"negbin"}, or \code{"constant"}.
Defaults to \code{"gaussian"}.}

\item{dist.sizeb}{A string value giving the distribution of the variable
coding secondary size. Can equal \code{"none"}, \code{"gamma"},
\code{"gaussian"}, \code{"poisson"}, \code{"negbin"}, or \code{"constant"}.
Defaults to \code{"constant"}.}

\item{dist.sizec}{A string value giving the distribution of the variable
coding tertiary size. Can equal \code{"none"}, \code{"gamma"},
\code{"gaussian"}, \code{"poisson"}, \code{"negbin"}, or \code{"constant"}.
Defaults to \code{"constant"}.}

\item{dist.fec}{A string value giving the distribution of the variable
coding fecundity. Can equal \code{"none"}, \code{"gamma"},
\code{"gaussian"}, \code{"poisson"}, or \code{"negbin"}. Defaults to
\code{"gaussian"}.}

\item{trunc.sizea}{A logical value indicating whether the distribution of the
primary size variable should be zero-truncated. Defaults to \code{FALSE}.
Currently only works with the Poisson and negative binomial distributions.}

\item{trunc.sizeb}{A logical value indicating whether the distribution of the
secondary size variable should be zero-truncated. Defaults to \code{FALSE}.
Currently only works with the Poisson and negative binomial distributions.}

\item{trunc.sizec}{A logical value indicating whether the distribution of the
tertiary size variable should be zero-truncated. Defaults to \code{FALSE}.
Currently only works with the Poisson and negative binomial distributions.}

\item{trunc.fec}{A logical value indicating whether the distribution of the
fecundity variable should be zero-truncated. Defaults to \code{FALSE}.
Currently only works with the Poisson and negative binomial distributions.}

\item{use.juv}{A logical value indicating whether to utilize juvenile vital
rates. If \code{FALSE}, then all juvenile vital rates will be set to
\code{constant} distributions. Defaults to \code{FALSE}.}
}
\value{
A list of class \code{vrm_input}, with up to 13 elements including:
\item{vrm_frame}{A data frame holding the main slope coefficients for the
linear vital rate models.}
\item{year_frame}{A data frame holding the main slope coefficients for the
year at time t terms in the linear vital rate models.}
\item{patch_frame}{A data frame holding the main slope coefficients for the
patch terms in the linear vital rate models.}
\item{group2_frame}{A data frame holding the main slope coefficients for the
stage group terms in time \emph{t} in the linear vital rate models.}
\item{group1_frame}{A data frame holding the main slope coefficients for the
stage group terms in time \emph{t}-1 in the linear vital rate models.}
\item{dist_frame}{A data frame giving the distributions of all variables,
including primary, secondary, and tertiary size, and fecundity. Some
variables begin as \code{constant}.}
\item{indcova2_frame}{A data frame holding the main slope coefficients for
the categorical individual covariate a terms in time \emph{t} in the linear
vital rate models.}
\item{indcova1_frame}{A data frame holding the main slope coefficients for
the categorical individual covariate a terms in time \emph{t}-1 in the linear
vital rate models.}
\item{indcovb2_frame}{A data frame holding the main slope coefficients for
the categorical individual covariate b terms in time \emph{t} in the linear
vital rate models.}
\item{indcovb1_frame}{A data frame holding the main slope coefficients for
the categorical individual covariate b terms in time \emph{t}-1 in the linear
vital rate models.}
\item{indcovc2_frame}{A data frame holding the main slope coefficients for
the categorical individual covariate c terms in time \emph{t} in the linear
vital rate models.}
\item{indcovc1_frame}{A data frame holding the main slope coefficients for
the categorical individual covariate c terms in time \emph{t}-1 in the linear
vital rate models.}
\item{st_frame}{A data frame holding values of sigma or theta for use in
Gaussian or negative binomial response terms, respectively.}

The first element, called \code{vrm_frame}, is a data frame with the
following 18 variables:
\item{main_effect_1}{The main effect for which coefficients are to be
entered.}
\item{main_1_defined}{A more natural explanation of \code{main_effect_1}.}
\item{main_effect_2}{If given, then indicates another effect in a two-way
interaction with \code{main_effect_1}.}
\item{main_2_defined}{A more natural explanation of \code{main_effect_2}.}
\item{surv}{A vector of coefficients for the factors in the model of adult
survival.}
\item{obs}{A vector of coefficients for the factors in the model of adult
observation status.}
\item{sizea}{A vector of coefficients for the factors in the model of adult
primary size.}
\item{sizeb}{A vector of coefficients for the factors in the model of adult
secondary size.}
\item{sizec}{A vector of coefficients for the factors in the model of adult
tertiary size.}
\item{repst}{A vector of coefficients for the factors in the model of adult
reproductive status.}
\item{fec}{A vector of coefficients for the factors in the model of adult
fecundity.}
\item{jsurv}{A vector of coefficients for the factors in the model of
juvenile survival.}
\item{jobs}{A vector of coefficients for the factors in the model of juvenile
observation status.}
\item{jsize}{A vector of coefficients for the factors in the model of
juvenile primary size.}
\item{jsizeb}{A vector of coefficients for the factors in the model of
juvenile secondary size.}
\item{jsizec}{A vector of coefficients for the factors in the model of
juvenile tertiary size.}
\item{jrepst}{A vector of coefficients for the factors in the model of
juvenile reproductive status, for individuals maturing in the current time
step.}
\item{jmat}{A vector of coefficients for the factors in the model of maturity
status, for individuals capable of maturing at the current time step.}
\item{sizea_zi}{A vector of coefficients for the factors in the binomial
component of the zero-inflated model of adult primary size, if zero-inflated
models are being used.}
\item{sizeb_zi}{A vector of coefficients for the factors in the binomial
component of the zero-inflated model of adult secondary size, if
zero-inflated models are being used.}
\item{sizec_zi}{A vector of coefficients for the factors in the binomial
component of the zero-inflated model of adult tertiary size, if zero-inflated
models are being used.}
\item{fec_zi}{A vector of coefficients for the factors in the binomial
component of the zero-inflated model of fecundity, if zero-inflated models
are being used.}
\item{jsizea_zi}{A vector of coefficients for the factors in the binomial
component of the zero-inflated model of juvenile primary size, if
zero-inflated models are being used.}
\item{jsizeb_zi}{A vector of coefficients for the factors in the binomial
component of the zero-inflated model of juvenile secondary size, if
zero-inflated models are being used.}
\item{jsizec_zi}{A vector of coefficients for the factors in the binomial
component of the zero-inflated model of juvenile tertiary size, if
zero-inflated models are being used.}
}
\description{
Function \code{vrm_import()} builds a skeleton list holding data frames and
vectors that can be used to import coefficient values for the factors of the
vital rate models used to build function-based MPMs or run function-based
projections.
}
\section{Notes}{

All coefficients across all data frames are initially set to \code{0}. After
using this function to create the skeleton list, all relevant coefficient
values should be set to non-zero values equal to the respective slope from
the appropriate linear model, and any vital rate model to be used should
have its distribution set to \code{"binom"}, \code{"gaussian"},
\code{"gamma"}, \code{"poisson"}, or \code{"negbin"}. Unused vital rates
should be set to \code{"constant"}, and the first element of the correspoding
column in \code{vrm_frame} (corresponding to the y-intercept) should be set
to the constant value to utilize (generally \code{1}). If no values are
manually edited, then function-based MPM generator functions will not be able
to generate valid MPMs.

Users should never change the labels or the order of terms in the data frames
and vectors produced via this function, nor should they ever changes the
names of core list elements in the \code{vrm_input} object. Doing so will
result either in fatal errors or erroneous matrix calculations.

Using the \code{vrm_import()} approach to building function-based MPMs
requires attention to the stageframe. Although no \code{hfv_data} object
needs to be input, stages for which vital rates are to be estimated via
models parameterized with coefficients provided via function
\code{vrm_import()} should be marked as occurring within the dataset, while
stages for which the provided coefficients should not be used should be
marked as not occurring within the dataset.

Coefficients added to zero-inflation models can only be added to primary
size, secondary size, tertiary size, fecundity, and the juvenile versions of
primary, secondary, and tertiary size. Care must be taken to include zero-
inflated coefficients only for variables without size-truncated
distributions. Adding such terms will result in fatal errors during matrix
creation.
}

\examples{
data(lathyrus)

sizevector <- c(0, 100, 0, 1, 7100)
stagevector <- c("Sd", "Sdl", "Dorm", "ipm", "ipm")
repvector <- c(0, 0, 0, 1, 1)
obsvector <- c(0, 1, 0, 1, 1)
matvector <- c(0, 0, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1)
binvec <- c(0, 100, 0.5, 1, 1)
comments <- c("Dormant seed", "Seedling", "Dormant", "ipm adult stage",
  "ipm adult stage")
lathframeipm <- sf_create(sizes = sizevector, stagenames = stagevector, 
  repstatus = repvector, obsstatus = obsvector, propstatus = propvector,
  immstatus = immvector, matstatus = matvector, comments = comments,
  indataset = indataset, binhalfwidth = binvec, ipmbins = 100, roundsize = 3)

lathsupp2 <- supplemental(stage3 = c("Sd", "Sdl", "Sd", "Sdl"),
  stage2 = c("Sd", "Sd", "rep", "rep"),
  givenrate = c(0.345, 0.054, NA, NA),
  multiplier = c(NA, NA, 0.345, 0.054),
  type = c(1, 1, 3, 3), stageframe = lathframeipm, historical = FALSE)

lath_vrm <- vrm_import(years = c(1988:1990), zi = TRUE, dist.fec = "negbin",
  use.juv = TRUE)

lath_vrm$vrm_frame$surv[1] <- 2.32571
lath_vrm$vrm_frame$surv[2] <- 0.00109
lath_vrm$vrm_frame$obs[1] <- 2.230
lath_vrm$vrm_frame$sizea[1] <- 164.0695
lath_vrm$vrm_frame$sizea[2] <- 0.6211
lath_vrm$vrm_frame$fec[1] <- 1.517
lath_vrm$vrm_frame$fec_zi[1] <- 6.252765
lath_vrm$vrm_frame$fec_zi[2] <- -0.007313
lath_vrm$vrm_frame$jsurv[1] <- 1.03
lath_vrm$vrm_frame$jobs[1] <- 10.390
lath_vrm$vrm_frame$jsizea[1] <- 3.0559
lath_vrm$vrm_frame$jsizea[2] <- 0.8482

lath_vrm$year_frame$fec[c(1:3)] <- c(-0.41749627, 0.51421684, -0.07964038)
lath_vrm$year_frame$fec_zi[c(1:3)] <- c(3.741475e-07, -7.804715e-08,
  -2.533755e-07)
lath_vrm$year_frame$sizea[c(1:3)] <- c(96.3244, -240.8036, 144.4792)
lath_vrm$year_frame$jobs[c(1:3)] <- c(-0.7459843, 0.6118826, -0.9468618)
lath_vrm$year_frame$jsizea[c(1:3)] <- c(0.5937962, 1.4551236, -2.0489198)

lath_vrm$dist_frame$dist[2] <- "binom"
lath_vrm$dist_frame$dist[9] <- "binom"

lath_vrm$st_frame[3] <- 503.6167
lath_vrm$st_frame[7] <- 0.2342114
lath_vrm$st_frame[10] <- 5.831

lath_vrm$vrm_frame$sizeb[1] <- 1
lath_vrm$vrm_frame$sizec[1] <- 1
lath_vrm$vrm_frame$repst[1] <- 1
lath_vrm$vrm_frame$jsizeb[1] <- 1
lath_vrm$vrm_frame$jsizec[1] <- 1
lath_vrm$vrm_frame$jrepst[1] <- 1
lath_vrm$vrm_frame$jmatst[1] <- 1

lathmat2_importipm <- flefko2(stageframe = lathframeipm,
  modelsuite = lath_vrm, supplement = lathsupp2, reduce = FALSE)

summary(lathmat2_importipm)

}
