% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_model_fit.R
\name{check_model_fit}
\alias{check_model_fit}
\title{Check the fit of estimated self-correcting model on the reference point pattern dataset}
\usage{
check_model_fit(
  reference_data,
  t_min = 0,
  t_max = 1,
  sc_params = NULL,
  anchor_point = NULL,
  raster_list = NULL,
  scaled_rasters = FALSE,
  mark_model = NULL,
  xy_bounds = NULL,
  include_comp_inds = FALSE,
  thinning = TRUE,
  correction = "none",
  competition_radius = 15,
  n_sim = 2500,
  save_sims = TRUE,
  verbose = TRUE,
  seed = 0
)
}
\arguments{
\item{reference_data}{a ppp object for the reference dataset.}

\item{t_min}{minimum value for time.}

\item{t_max}{maximum value for time.}

\item{sc_params}{vector of parameter values corresponding to (alpha_1, beta_1, gamma_1, alpha_2, beta_2, alpha_3, beta_3, gamma_3).}

\item{anchor_point}{vector of (x,y) coordinates of point to condition on.}

\item{raster_list}{a list of raster objects.}

\item{scaled_rasters}{`TRUE` or `FALSE` indicating whether the rasters have been scaled.}

\item{mark_model}{a model object (typically from \code{train_mark_model}).}

\item{xy_bounds}{a vector of domain bounds (2 for x, 2 for y).}

\item{include_comp_inds}{`TRUE` or `FALSE` indicating whether to generate and use competition indices as covariates.}

\item{thinning}{`TRUE` or `FALSE` indicating whether to use the thinned or unthinned simulated values.}

\item{correction}{type of correction to apply ("none" or "toroidal").}

\item{competition_radius}{distance for competition radius if \code{include_comp_inds} is `TRUE`.}

\item{n_sim}{number of simulated datasets to generate.}

\item{save_sims}{`TRUE` or `FALSE` indicating whether to save and return the simulated datasets.}

\item{verbose}{`TRUE` or `FALSE` indicating whether to show progress of model checking.}

\item{seed}{an integer value to set the seed for reproducibility.}
}
\value{
a list containing a combined global envelope test, individual global envelope tests for the L, F, G, J, E, and V functions, and simulated metric values (if specified).
}
\description{
Allows the user to perform global envelope tests for the nonparametric L, F, G, J, E, and V summary functions from the \code{spatstat} package.
These tests serve as a goodness of fit measure for the estimated model relative to the reference dataset of interest.
}
\details{
This function relies on the \code{spatstat} package for the calculation of the point pattern metrics
and the \code{GET} package for the global envelope tests. The L, F, G, J, E, and V functions are a collection of
non-parametric summary statistics that describe the spatial distribution of points and marks in a point pattern.
See the documentation for [spatstat.explore::Lest()], [spatstat.explore::Fest()], [spatstat.explore::Gest()],
[spatstat.explore::Jest()], [spatstat.explore::Emark()], and [spatstat.explore::Vmark()] for more information.
Also, see the [GET::global_envelope_test()] function for more information on the global envelope tests.
}
\examples{
# Note: The example below is provided for illustrative purposes and may take some time to run.
\donttest{
# Load the small example data
data(small_example_data)

# Load the example mark model that previously was trained on the small example data
file_path <- system.file("extdata", "example_mark_model.rds", package = "ldmppr")
mark_model <- load_mark_model(file_path)

# Load the raster files
raster_paths <- list.files(system.file("extdata", package = "ldmppr"),
                           pattern = "\\\\.tif$", full.names = TRUE)
raster_paths <- raster_paths[!grepl("_med\\\\.tif$", raster_paths)]
rasters <- lapply(raster_paths, terra::rast)

# Scale the rasters
scaled_raster_list <- scale_rasters(rasters)

# Generate the reference pattern
reference_data <- generate_mpp(
  locations = small_example_data[, c("x", "y")],
  marks = small_example_data$size,
  xy_bounds = c(0, 25, 0, 25)
)

# Define an anchor point
M_n <- c(small_example_data[1, c("x", "y")])

# Specify the estimated parameters of the self-correcting process
# Note: These would generally be estimated using estimate_process_parameters.
# These values are estimates from the small_example_data generating script.
estimated_parameters <- c(
  0.05167978, 8.20702166, 0.02199940, 2.63236890,
  1.82729512, 0.65330061, 0.86666748, 0.04681878
)

# Check the model fit
example_model_fit <- check_model_fit(
  reference_data = reference_data,
  t_min = 0,
  t_max = 1,
  sc_params = estimated_parameters,
  anchor_point = M_n,
  raster_list = scaled_raster_list,
  scaled_rasters = TRUE,
  mark_model = mark_model,
  xy_bounds = c(0, 25, 0, 25),
  include_comp_inds = TRUE,
  thinning = TRUE,
  correction = "none",
  competition_radius = 10,
  n_sim = 100,
  save_sims = FALSE,
  verbose = TRUE,
  seed = 90210
)

plot(example_model_fit, which = 'combined')
}
}
\references{
Baddeley, A., Rubak, E., & Turner, R. (2015). *Spatial Point Patterns:
Methodology and Applications with R*. Chapman and Hall/CRC Press, London.
ISBN 9781482210200. Available at:
\url{https://www.routledge.com/Spatial-Point-Patterns-Methodology-and-Applications-with-R/Baddeley-Rubak-Turner/p/book/9781482210200}.

Myllymäki, M., & Mrkvička, T. (2023). GET: Global envelopes in R.
\emph{arXiv:1911.06583 [stat.ME]}. \doi{10.48550/arXiv.1911.06583}.
}
