% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamin_cli.R
\name{lamin_cli}
\alias{lamin_cli}
\alias{lamin_connect}
\alias{lamin_disconnect}
\alias{lamin_login}
\alias{lamin_logout}
\alias{lamin_init}
\alias{lamin_init_temp}
\alias{lamin_delete}
\alias{lamin_save}
\alias{lamin_settings}
\title{Lamin CLI functions}
\usage{
# Import the module instead of using deprecated functions
# lc <- import_module("lamin_cli")

# Deprecated functions

lamin_connect(instance)

lamin_disconnect()

lamin_login(user = NULL, api_key = NULL)

lamin_logout()

lamin_init(storage, name = NULL, db = NULL, modules = NULL)

lamin_init_temp(
  name = "laminr-temp",
  db = NULL,
  modules = NULL,
  add_timestamp = TRUE,
  envir = parent.frame()
)

lamin_delete(instance, force = FALSE)

lamin_save(filepath, key = NULL, description = NULL, registry = NULL)

lamin_settings()
}
\arguments{
\item{instance}{Either a slug giving the instance to connect to
(\verb{<owner>/<name>}) or an instance URL (\verb{https://lamin.ai/owner/name}). For
\code{lamin_delete()}, the slug for the instance to delete.}

\item{user}{Handle for the user to login as}

\item{api_key}{API key for a user}

\item{storage}{A local directory, AWS S3 bucket or Google Cloud Storage bucket}

\item{name}{A name for the instance}

\item{db}{A Postgres database connection URL, use \code{NULL} for SQLite}

\item{modules}{A vector of modules to include (e.g. "bionty")}

\item{add_timestamp}{Whether to append a timestamp to \code{name} to make it unique}

\item{envir}{An environment passed to \code{\link[withr:defer]{withr::defer()}}}

\item{force}{Whether to force deletion without asking for confirmation}

\item{filepath}{Path to the file or folder to save}

\item{key}{The key for the saved item}

\item{description}{The description for the saved item}

\item{registry}{The registry for the saved item}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Lamin CLI calls are available from R by importing the \strong{lamin_cli} Python
module using \code{lc <- import_module("lamin_cli")}. The previous CLI functions
are now deprecated, see examples for how to switch to the new syntax.
}
\details{
\subsection{\code{lamin_connect()}}{

Running this will set the LaminDB auto-connect option to \code{True} so you
auto-connect to \code{instance} when importing Python \code{lamindb}.
}

\subsection{\code{lamin_login()}}{

Depending on the input, one of these commands will be run (in this order):
\enumerate{
\item If \code{user} is set then \verb{lamin login <user>}
\item Else if \code{api_key} is set then set the \code{LAMIN_API_KEY} environment variable
temporarily with \code{withr::with_envvar()} and run \verb{lamin login}
\item Else if there is a stored user handle run \verb{lamin login <handle>}
\item Else if the \code{LAMIN_API_KEY} environment variable is set run \verb{lamin login}
}

Otherwise, exit with an error
}

\subsection{\code{lamin_init_temp()}}{

For \code{\link[=lamin_init_temp]{lamin_init_temp()}}, a time stamp is appended to \code{name} (if
\code{add_timestamp = TRUE}) and then a new instance is initialised with
\code{\link[=lamin_init]{lamin_init()}} using a temporary directory. A \code{\link[=lamin_delete]{lamin_delete()}} call is
registered as an exit handler with \code{\link[withr:defer]{withr::defer()}} to clean up the instance
when \code{envir} finishes.

The \code{\link[=lamin_init_temp]{lamin_init_temp()}} function is mostly for internal use and in most cases
users will want \code{\link[=lamin_init]{lamin_init()}}.
}
}
\examples{
\dontrun{
# Import Lamin modules
lc <- import_module("lamin_cli")
ln <- import_module("lamindb")

# Examples of replacing CLI functions with the lamin_cli module
}
\dontrun{
# Connect to a LaminDB instance
lamin_connect(instance)
# ->
lc$connect(instance)
}
\dontrun{
# Disconnect from a LaminDB instance
lamin_disconnect()
# ->
lc$disconnect()
}
\dontrun{
# Log in as a LaminDB user
lamin_login(...)
# ->
lc$login(...)
}
\dontrun{
# Log out of LaminDB
lamin_logout()
# ->
lc$logout()
}
\dontrun{
# Create a new LaminDB instance
lamin_init(...)
# ->
lc$init(...)
}
\dontrun{
# Create a temporary LaminDB instance
lamin_init_temp(...)
# ->
create_temporary_instance()
}
\dontrun{
# Delete a LaminDB entity
lamin_delete(...)
# ->
lc$delete(...)
}
\dontrun{
# Save to a LaminDB instance
lamin_save(...)
# ->
lc$save(...)
}
\dontrun{
# Access Lamin settings
lamin_settings()
# ->
ln$setup$settings
# OR
ln$settings
# Alternatively
get_current_lamin_settings()
}
}
