% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-aliases.R
\name{new_layer_class}
\alias{new_layer_class}
\title{Layer}
\usage{
new_layer_class(
  classname,
  initialize = NULL,
  call = NULL,
  build = NULL,
  get_config = NULL,
  ...,
  public = list(),
  private = list(),
  inherit = NULL,
  parent_env = parent.frame()
)
}
\arguments{
\item{classname}{String, the name of the custom class. (Conventionally, CamelCase).}

\item{initialize, call, build, get_config}{Recommended methods to implement. See
description and details sections.}

\item{..., public}{Additional methods or public members of the custom class.}

\item{private}{Named list of R objects (typically, functions) to include in
instance private environments. \code{private} methods will have all the same
symbols in scope as public methods (See section "Symbols in Scope"). Each
instance will have it's own \code{private} environment. Any objects
in \code{private} will be invisible from the Keras framework and the Python
runtime.}

\item{inherit}{What the custom class will subclass. By default, the base keras class.}

\item{parent_env}{The R environment that all class methods will have as a grandparent.}
}
\value{
A composing layer constructor, with similar behavior to other layer
functions like \code{layer_dense()}. The first argument of the returned function
will be \code{object}, enabling \code{initialize()}ing and \code{call()} the layer in one
step while composing the layer with the pipe, like

\if{html}{\out{<div class="sourceCode r">}}\preformatted{layer_foo <- Layer("Foo", ....)
output <- inputs |> layer_foo()
}\if{html}{\out{</div>}}

To only \code{initialize()} a layer instance and not \code{call()} it, pass a missing
or \code{NULL} value to \code{object}, or pass all arguments to \code{initialize()} by name.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{layer <- layer_dense(units = 2, activation = "relu")
layer <- layer_dense(NULL, 2, activation = "relu")
layer <- layer_dense(, 2, activation = "relu")

# then you can call() the layer in a separate step
outputs <- inputs |> layer()
}\if{html}{\out{</div>}}
}
\description{
\code{new_layer_class()} is an alias for \code{\link[=Layer]{Layer()}}.
See \verb{?}\code{\link[=Layer]{Layer()}} for the full documentation.
}
\keyword{internal}
