% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers-schedules.R
\name{learning_rate_schedule_piecewise_constant_decay}
\alias{learning_rate_schedule_piecewise_constant_decay}
\title{A \code{LearningRateSchedule} that uses a piecewise constant decay schedule.}
\usage{
learning_rate_schedule_piecewise_constant_decay(
  boundaries,
  values,
  name = "PiecewiseConstant"
)
}
\arguments{
\item{boundaries}{A list of Python numbers with strictly increasing
entries, and with all elements having the same type as the
optimizer step.}

\item{values}{A list of Python numbers that specifies the values for the
intervals defined by \code{boundaries}. It should have one more
element than \code{boundaries}, and all elements should have the same
type.}

\item{name}{A string. Optional name of the operation. Defaults to
\code{"PiecewiseConstant"}.}
}
\value{
A 1-arg callable learning rate schedule that takes the current optimizer
step and outputs the decayed learning rate, a scalar tensor of the
same type as the boundary tensors.

The output of the 1-arg function that takes the \code{step}
is \code{values[0]} when \code{step <= boundaries[0]},
\code{values[1]} when \code{step > boundaries[0]} and \code{step <= boundaries[1]},
..., and \code{values[-1]} when \code{step > boundaries[-1]}.
}
\description{
The function returns a 1-arg callable to compute the piecewise constant
when passed the current optimizer step. This can be useful for changing the
learning rate value across different invocations of optimizer functions.
}
\section{Examples}{
use a learning rate that's 1.0 for the first 100001 steps, 0.5
for the next 10000 steps, and 0.1 for any additional steps.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{step <- 0
boundaries <- c(100000, 110000)
values <- c(1.0, 0.5, 0.1)
learning_rate_fn <- learning_rate_schedule_piecewise_constant_decay(
  boundaries, values)

# Later, whenever we perform an optimization step, we pass in the step.
learning_rate <- learning_rate_fn(step)
}\if{html}{\out{</div>}}

You can pass this schedule directly into a \code{optimizer}
as the learning rate. The learning rate schedule is also serializable and
deserializable using \code{keras$optimizers$schedules$serialize} and
\code{keras$optimizers$schedules$deserialize}.
}

\section{Raises}{
ValueError: if the number of elements in the \code{boundaries} and \code{values}
lists do not match.
}

\seealso{
\itemize{
\item \url{https://keras.io/api/optimizers/learning_rate_schedules/piecewise_constant_decay#piecewiseconstantdecay-class}
}

Other optimizer learning rate schedules: \cr
\code{\link{LearningRateSchedule}()} \cr
\code{\link{learning_rate_schedule_cosine_decay}()} \cr
\code{\link{learning_rate_schedule_cosine_decay_restarts}()} \cr
\code{\link{learning_rate_schedule_exponential_decay}()} \cr
\code{\link{learning_rate_schedule_inverse_time_decay}()} \cr
\code{\link{learning_rate_schedule_polynomial_decay}()} \cr
}
\concept{optimizer learning rate schedules}
