% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyNumberCalculation.R
\name{calcCopyNumber}
\alias{calcCopyNumber}
\alias{generateControlCopyNumberTemplate}
\title{Calculate relative copy number value for each cell-probe unit using reference sample}
\usage{
calcCopyNumber(
  TapestriExperiment,
  control.copy.number,
  sample.feature = "cluster",
  remove.bad.probes = FALSE
)

generateControlCopyNumberTemplate(
  TapestriExperiment,
  copy.number = 2,
  sample.feature.label = NA
)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object.}

\item{control.copy.number}{\code{data.frame} with columns \code{arm}, \code{copy.number}, and \code{sample.label}. See details.}

\item{sample.feature}{Character, \code{colData} column to use for subsetting cell.barcodes. Default "cluster".}

\item{remove.bad.probes}{Logical, if \code{TRUE}, probes with median normalized counts = 0 are removed from the returned \code{TapestriExperiment}. If FALSE (default), probes with median normalized counts = 0 throw error and stop function.}

\item{copy.number}{Numeric, sets all entries of \code{copy.number} column in output. Default 2 (diploid).}

\item{sample.feature.label}{Character, sets all entries of \code{sample.label} column in output.}
}
\value{
\code{TapestriExperiment} object with cell-probe copy number values in \code{copyNumber} assay slot.

\code{data.frame} with 3 columns named \code{arm}, \code{copy.number}, and \code{sample.label}
}
\description{
\code{calcCopyNumber()} transforms the normalized count matrix \code{normcounts} of a \code{TapestriExperiment} object
into copy number values based on a set of reference cell barcodes and given copy number value (e.g. 2 for diploid).
This is practically used to set the median copy number of a usually diploid reference
cell population to a known copy number value, e.g. 2, and then calculate the copy number for all the
cells relative to that reference population. This occurs individually for each probe,
such that the result is one copy number value per cell barcode per probe (cell-probe unit).
\code{control.copy.number} is a \code{data.frame} lookup table used to indicate the copy number value and cell barcodes
to use as the reference. A template for \code{control.copy.number} can be generated using \code{\link[=generateControlCopyNumberTemplate]{generateControlCopyNumberTemplate()}},
which will have a row for each chromosome arm represented in \code{TapestriExperiment}.

The \code{control.copy.number} data.frame should include 3 columns named \code{arm}, \code{copy.number}, and \code{sample.label}.
\code{arm} is chromosome arm names from chr1p through chrXq, \code{copy.number} is the reference copy number value (2 = diploid), and \code{sample.label} is the
value corresponding to the \code{colData} column given in \code{sample.feature} to indicate the set of reference cell barcodes to use to set the copy number.
This is best used in a workflow where the cells are clustered first into their respective samples, and then one cluster is used as the reference population
the other clusters. This also allows for the baseline copy number to be set for each chromosome arm individually in the case where the
reference population is not completely diploid.
}
\section{Functions}{
\itemize{
\item \code{generateControlCopyNumberTemplate()}: generates a \code{data.frame} template for \code{control.copy.number} in \code{calcCopyNumber()}.

}}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
tap.object <- calcNormCounts(tap.object)
control.copy.number <- generateControlCopyNumberTemplate(tap.object,
  copy.number = 2,
  sample.feature.label = "cellline1"
)
tap.object <- calcCopyNumber(tap.object,
  control.copy.number,
  sample.feature = "test.cluster"
)
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
control.copy.number <- generateControlCopyNumberTemplate(tap.object,
  copy.number = 2,
  sample.feature.label = "cellline1"
)
}
\concept{copy number}
