% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_imb.R
\name{inspect_imb}
\alias{inspect_imb}
\title{Summarise and compare columnwise imbalance for non-numeric columns in one or two dataframes.}
\usage{
inspect_imb(df1, df2 = NULL, show_plot = FALSE, include_na = FALSE)
}
\arguments{
\item{df1}{A dataframe.}

\item{df2}{An optional second data frame for comparing columnwise imbalance.
Defaults to \code{NULL}.}

\item{show_plot}{(Deprecated) Logical flag indicating whether a plot should be shown.
Superseded by the function \code{show_plot()} and will be dropped in a future version.}

\item{include_na}{Logical flag, whether to include missing values as a unique level.  Default
is \code{FALSE} - to ignore \code{NA} values.}
}
\value{
A tibble summarising and comparing the imbalance for each non-numeric column 
in one or a pair of data frames.
}
\description{
Summarise and compare columnwise imbalance for non-numeric columns in one or two dataframes.
}
\details{
When \code{df2 = NULL}, a tibble containing a summary of columnwise imbalance 
is returned, with columns:
\itemize{
  \item \code{col_name} character vector containing column names of \code{df1}.
  \item \code{value} character vector containing the most common categorical level 
  in each column of \code{df1}.
  \item \code{pcnt} the relative frequency of each column's most common categorical level 
  expressed as a percentage.
  \item \code{cnt} the number of occurrences of the most common categorical level in each
  column of \code{df1}.
}
When both \code{df1} and \code{df2} are specified, the most common levels in features common 
to both \code{df1} and \code{df2} is returned. A simple test of the null hypothesis that the 
relative frequencies of a common level is the same in both dataframes is performed.  
The resulting tibble has columns
\itemize{
  \item \code{col_name} character vector containing names of the unique columns in \code{df1} 
  and \code{df2}.
  \item \code{value} character vector containing the most common categorical level 
  in each column of \code{df1}.  
  \item \code{pcnt_} the percentage of each column's entries occupied by the level in
  \code{value} column.
  \item \code{cnt_} the number of occurrences of the most common categorical level in each
  column of \code{df1} and \code{df2}.
}
}
\examples{
data("starwars", package = "dplyr")
# get tibble of most common levels
inspect_imb(starwars)
# compare imbalance 
inspect_imb(starwars, starwars[1:10, -3])
}
