% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_segment_detector.R
\name{plot.lsd}
\alias{plot.lsd}
\title{Plot the detected lines from the image_line_segment_detector}
\usage{
\method{plot}{lsd}(x, ...)
}
\arguments{
\item{x}{an object of class lsd as returned by \code{\link{image_line_segment_detector}}}

\item{...}{further arguments passed on to plot}
}
\value{
invisibly a SpatialLines object with the lines
}
\description{
Plot the detected lines from the image_line_segment_detector
}
\examples{
library(pixmap)
imagelocation <- system.file("extdata", "le-piree.pgm", package="image.LineSegmentDetector")
image <- read.pnm(file = imagelocation, cellres = 1)
linesegments <- image_line_segment_detector(image@grey * 255)
plot(image)
plot(linesegments, add = TRUE, col = "red")
}
