% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypsoFunc.R
\name{drawHypsoCurves}
\alias{drawHypsoCurves}
\title{Draw Hypsometric curves and calculate hypsometric integrals}
\usage{
drawHypsoCurves(x, y, print_result = FALSE)
}
\arguments{
\item{x}{An object of class SpatialPolygonsDataFrame or simple features (sf).
For instance, you can use RGDAL package's "readOGR()" function to create such an object from Shapefiles saved on disk.
Alternatively, you can use sf's st_read() function to get a simple features object from the shapefile.
NB: at least one column (attribute) named 'Name' should be present in the shapefile or input data frame.}

\item{y}{An object of class RasterLayer. You can use the raster package to read GeoTIFF and other raster formats from disk.}

\item{print_result}{A logical variable to decide whether the output folder will be created to contain the figures and summary table (CSV) or not.}
}
\value{
A data frame containing the hypsometric integral for each sub-catchment along with other data such as maximum &  minimum elevation.
}
\description{
This function takes as input the DEM and sub-catchments boundaries and calls the hypsoTables function to produce the hypsometric tables.
It then draws and prints out the hypsometric curves for each sub-catchment.
Then, it fits a function to the table of each sub-cacthment and uses it to calculate the hypsometric integral.
Finally, it summarizes the results in a well-formatted table and prints it out as CSV.
All these results are stored in a folder called "HYPSO_OUTPUT" created in the current working directory.
}
\details{
The elevation range of each sub-cacthment is divided into 30 contour intervals and the area covered by each contour interval is calculated.
The result is put into tables (one table for each sub-catchment).
This data is then used to construct the hypsometric curve through ggplot2.
A 3rd polynomial function is then fitted to the normalized table and PolynomF package is used to calculate the area under the hypsometric curve (its integral).
Finally,  the integral values for each sub-catchment are compiled into a data frame that is exported as CSV.
}
\examples{
\donttest{drawHypsoCurves(watersheds, DEM)} #Draw hypsographic curves of the sub-catchments in 'watersheds'.

}
\seealso{
\code{\link{lm}}
}
\author{
Faustin Gashakamba \email{gashakamba@gmail.com}
}
