% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pfas.clearance}
\alias{pfas.clearance}
\title{Interspecies In vivo Clearance Data for PFAS}
\format{
data.frame
}
\usage{
pfas.clearance
}
\description{
If the chemical- and species-specific TK half-life (\eqn{t_{1/2}}) and volume of 
distribution (\eqn{V_{d}}) are known, a whole-body plasma clearance rate can be 
calculated as: \deqn{Cl_{tot} = ln(1/2) / t_{1/2} * V_{d}}
The first term involving the natural logarithm of 1/2 converts half-life (h) 
into an elimination rate (1/h) so that \eqn{Cl_{tot}} has units of 
L/kg bodyweight/h. 
Dawson et al. (2023) reported a table of in vivo PFAS \eqn{t_{1/2}} data for multiple 
species across eleven PFAS. Most of the measured data are for rodents. These
 data result from a series of reviews of the literature by 
Lau et al. (most recently Fenton et al. 2021) that were further revised for
Dawson et al. (2023).
Dawson et al. (2023) Supplemental Information S2.5 compiled \eqn{V_{d}}
values that 
were used here for calculating total clearance. A dataset of 
literature-derived values of \eqn{V_{d}} was compiled starting from 
Pizzurro et al. (2019) Table 2, which compiled 38 observations spanning 
five PFAS chemicals, four species, and both sexes from various literature 
sources. To these we added 24 calculated \eqn{V_{d}} observations in rat for three 
chemicals across a range of doses and routes from Huang et al. (2019). 
Further values for \eqn{V_{d}} were collected from the peer-review literature 
(Dzierlenga et al. 2020; Lau et al. 2020; Lou et al. 2009; Tatum-Gibbs et al. 2011).
 The total data set includes 128 values for \eqn{V_{d}} from 8 PFAS chemicals 
across 4 species. 
A \eqn{Cl_{tot}} was calculated using the above equation for every chemical- and 
species-specific half-life reported in the
 Dawson et al. (2023) supplemental materials. For chemicals without
 species- and compound-specific measurements for \eqn{V_{d}} we used the median
 in vivo measured PFAS Vd of 0.205 L/kg BW.
}
\details{
The data.frame contains the following columns:
\tabular{ll}{
\strong{Column Name} \tab \strong{Description} \cr
 DTXSID \tab CompTox Chemicals Dashboard substance identifier \cr                      
 Species \tab Species for which the clearance was calculated \cr
 Sex \tab Sex for which the clearance was calculated \cr
 HalfLifeHours \tab Half-life in hours \cr
 HlReference \tab Reference(s) for half-life \cr  
 VdLpkgbw  \tab Volume of distribution in L/kg body weight \cr
 VdReference \tab Reference for volume of distribution \cr
 Kelimph  \tab Elimination rate in 1/hour \cr
 ClLphpkgbw \tab Total clearance in L/h/kg body weight \cr
}
}
\references{
\insertRef{dawson2023machine}{httk}

\insertRef{fenton2021per}{httk}

\insertRef{pizzurro2019interspecies}{httk}

\insertRef{huang2019toxicokinetics}{httk}

\insertRef{dzierlenga2020toxicokinetics}{httk}

\insertRef{lau2020pharmacokinetic}{httk}

\insertRef{lou2009modeling}{httk}

\insertRef{tatum2011comparative}{httk}
}
\keyword{data}
