% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5T.R
\docType{class}
\name{H5T_INTEGER-class}
\alias{H5T_INTEGER-class}
\alias{H5T_INTEGER}
\alias{H5T_BITFIELD}
\title{Class for HDF5 integer-datatypes.}
\value{
Object of class \code{\link[=H5T_INTEGER]{H5T_INTEGER}}.
}
\description{
Inherits from class \code{\link[=H5T]{H5T}}.
Users should not create integer datatypes themselves using this class. Instead, integer should be derived
from one of the base-types such as \code{h5types$H5T_NATIVE_INT} (which internally automatically creates a copy of the type).
For a complete list of types see \code{h5types$overview}.
}
\section{Methods}{

\describe{
\item{\code{set_sign(sign)}}{

This function implements the HDF5-API function H5Tset_sign.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5T.html#Datatype-SetSign} for details.}

\item{\code{get_sign()}}{

This function implements the HDF5-API function H5Tget_sign.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5T.html#Datatype-GetSign} for details.}

\item{\code{describe()}}{

Return a vector that describes the key features of the datatype}
}}

\examples{
my_int <- h5types$H5T_NATIVE_INT

# make an int with 2 bit
my_int$set_sign(h5const$H5T_SGN_NONE)
my_int$set_size(1)
my_int$set_precision(2)
my_int$describe()
}
\seealso{
\code{\link[=H5T]{H5T}}
}
\author{
Holger Hoefling
}
