% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/har_eval_soft.R
\name{har_eval_soft}
\alias{har_eval_soft}
\title{Evaluation of event detection}
\usage{
har_eval_soft(sw_size = 15)
}
\arguments{
\item{sw_size}{tolerance window size}
}
\value{
\code{har_eval_soft} object
}
\description{
Evaluation of event detection using SoftED \url{doi:10.48550/arXiv.2304.00439}
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_anomalies)

#Using the simple
dataset <- examples_anomalies$simple
head(dataset)

# setting up time change point using GARCH
model <- hcp_garch()

# fitting the model
model <- fit(model, dataset$serie)

# making detections
detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

# evaluating the detections
evaluation <- evaluate(har_eval_soft(), detection$event, dataset$event)
print(evaluation$confMatrix)

# ploting the results
grf <- har_plot(model, dataset$serie, detection, dataset$event)
plot(grf)
}
