% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-hbr.R
\docType{methods}
\name{plot,hbr-method}
\alias{plot,hbr-method}
\alias{plot.hbr}
\title{Method to visualize reconstructed haplotype-blocks}
\usage{
\S4method{plot}{hbr}(x, min.marker = 1, xlab = "Genomic position [Mb]",
  ylab = "Reconstructed haplotype-block", main = "default", col = "black",
  lwd = 4, hline = 10, indicate_shared = F, addPoints = F,
  hbr_plot = NULL, ...)
}
\arguments{
\item{x}{object of class \code{hbr} containing the results of reconstructed haplotype
blocks for visualization.}

\item{min.marker}{numeric specifying the minimum number of markers a haplotype-block 
should contain in order to be visualized.}

\item{xlab}{Label of the x-axis with the default value 'Genomic position [MB]'.}

\item{ylab}{Label of the y-axis with the default value 'Reconstructe haplotype-block'.}

\item{main}{Plot title (default: "Chromosome XX").}

\item{col}{Color of the lines representing the haplotype-blocks (default: "black").}

\item{lwd}{Line width of the lines representing the haplotype-blocks (default: 4).}

\item{hline}{Distance between horizontal lines plotted for orientation (default: 10).}

\item{indicate_shared}{logical value specifying if "spurious" markers that are 
identical between pairs of haplotype-blocks should be indicated.
This function is usefull for inspecting results and deciding whether all
identified blocks are all independent or maybe reconstruction parameters should 
be changed.}

\item{addPoints}{logical value indicating if for each reconstructed block markers
should additionally be indicated.}

\item{hbr_plot}{boolean vector of length the number of reconstructed bocks indicating which
ones should be plotted}

\item{...}{arguments of the generic plot method.}
}
\description{
The method visualizes reconstructed haplotype-blocks for a chromosome.
}
\details{
The method operates on \code{\link{hbr}} objects and visualizes location of 
reconstructed haplotype-blocks with respect to its genomic position.
}
\author{
Susanne U. Franssen
}
\seealso{
\code{\link{hbr}} \code{\link{ex_dat}} \code{\link{summary.hbr}}
\code{\link{plot_cluster_trajectories}} \code{\link{plot_marker_trajectories}}
\code{\link{map}} \code{\link{rev_map}} \code{\link{markers}} \code{\link{plot_hbr_freq}}
\code{\link{inspect_window}} \code{\link{inspect_window_PCA}} \code{\link{inspect_window_avLink}}
\code{\link{inspect_window_dbScan}}\code{\link{number_hbr}}
}

