% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gutenberg_mirrors.R
\name{gutenberg_get_all_mirrors}
\alias{gutenberg_get_all_mirrors}
\title{Get all mirror data from Project Gutenberg}
\usage{
gutenberg_get_all_mirrors()
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} of Project Gutenberg mirrors and related data:
\describe{
\item{continent}{Continent where the mirror is located}
\item{nation}{Nation where the mirror is located}
\item{location}{Location of the mirror}
\item{provider}{Provider of the mirror}
\item{url}{URL of the mirror}
\item{note}{Special notes}
}
}
\description{
Get all mirror data from \url{https://www.gutenberg.org/MIRRORS.ALL}. This
only includes mirrors reported to Project Gutenberg and verified to be
relatively stable. For more information on mirroring and getting your own
mirror listed, see \url{https://www.gutenberg.org/help/mirroring.html}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
gutenberg_get_all_mirrors()
\dontshow{\}) # examplesIf}
}
\keyword{mirror}
