% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_gt.R
\name{as_gt}
\alias{as_gt}
\title{Convert gtsummary object to gt}
\usage{
as_gt(x, include = everything(), return_calls = FALSE, ...)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
An object of class \code{"gtsummary"}}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}.}

\item{return_calls}{Logical. Default is \code{FALSE}. If \code{TRUE}, the calls are returned
as a list of expressions.}

\item{...}{Arguments passed on to \code{gt::gt(...)}}
}
\value{
A \code{gt_tbl} object
}
\description{
Function converts a gtsummary object to a \code{"gt_tbl"} object,
that is, a table created with \code{gt::gt()}.
Function is used in the background when the results are printed or knit.
A user can use this function if they wish to add customized formatting
available via the \href{https://gt.rstudio.com/index.html}{gt package}.
}
\note{
As of 2024-08-15, line breaks (e.g. \code{'\\n'}) do not render properly for PDF output.
For now, these line breaks are stripped when rendering to PDF with Quarto and R markdown.
}
\examples{
# Example 1 ----------------------------------
trial |>
  tbl_summary(by = trt, include = c(age, grade, response)) |>
  as_gt()
}
\author{
Daniel D. Sjoberg
}
