% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_marks_ppp.R
\name{append_marks.ppp<-}
\alias{append_marks.ppp<-}
\title{Append to \link[spatstat.geom]{marks}}
\usage{
append_marks.ppp(x) <- value
}
\arguments{
\item{x}{a \link[spatstat.geom]{ppp.object}}

\item{value}{a \link[base]{factor} or \link[base]{numeric} \link[base]{vector}}
}
\value{
This syntax sugar returns a \link[spatstat.geom]{ppp.object}.
}
\description{
Append to \link[spatstat.geom]{marks}
}
\examples{
library(spatstat.geom)

# no marks
data(vesicles, package = 'spatstat.data')
plot(vesicles)
append_marks.ppp(vesicles) = rlnorm(n = npoints(vesicles))
plot(vesicles)

# vector marks, numeric
data(waka, package = 'spatstat.data')
plot(waka)
append_marks.ppp(waka) = rlnorm(n = npoints(waka))
plot(waka)

# vector marks, multitype
data(urkiola, package = 'spatstat.data')
plot(urkiola)
append_marks.ppp(urkiola) = rlnorm(n = npoints(urkiola))
plot(urkiola)

# dataframe marks
data(stonetools, package = 'spatstat.data')
plot(stonetools)
append_marks.ppp(stonetools) = rlnorm(n = npoints(stonetools))
plot(stonetools)
}
\keyword{internal}
