% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_numeric.R
\name{rank_numeric}
\alias{rank_numeric}
\title{Plackett-Luce rankings from numeric values}
\usage{
rank_numeric(
  data,
  items,
  input,
  id = NULL,
  group = FALSE,
  ascending = FALSE,
  ...
)
}
\arguments{
\item{data}{a data.frame with columns specified by items and input values}

\item{items}{a character or numerical vector for indexing the column(s) 
containing the item names in \code{data}}

\item{input}{a character or numerical vector for indexing the column(s) 
containing the values in \code{data} to be ranked}

\item{id}{an index of \code{data} indicating the 
ids for "long" \code{data}}

\item{group}{logical, if \code{TRUE} return an object of class "grouped_rankings"}

\item{ascending}{logical, only for floating point numbers, to 
compute rankings from lower to higher values}

\item{...}{additional arguments passed to methods}
}
\value{
a PlackettLuce "rankings" object, which is a matrix 
 of dense rankings
}
\description{
Group and coerce numeric values into Plackett-Luce rankings.
}
\examples{
# A matrix with 10 rankings of 5 items (A, B, C, D, E)
# with numeric values as "rank"
set.seed(123)
df = cbind(id = rep(1:10, each = 5),
            items = rep(LETTERS[1:5], times = 10),
            input = runif(50, 1, 3))

# return an object of class 'rankings'
R = rank_numeric(df,
                  items = 2,
                  input = 3,
                  id = 1)

# rankings can be computed in ascending order
R = rank_numeric(df,
                  items = 2,
                  input = 3,
                  id = 1,
                  ascending = TRUE)


# return an object of class 'grouped_rankings'
R = rank_numeric(df,
                  items = 2,
                  input = 3,
                  id = 1,
                  group = TRUE)

}
\seealso{
\code{\link[PlackettLuce]{rankings}}

Other rank functions: 
\code{\link{rank_tricot}()},
\code{\link{set_binomialfreq}()},
\code{\link{set_paircomp}()}
}
\author{
Kauê de Sousa
}
\concept{rank functions}
