% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_message.R
\name{gm_send_message}
\alias{gm_send_message}
\title{Send a message from a mime message}
\usage{
gm_send_message(
  mail,
  type = c("multipart", "media", "resumable"),
  thread_id = NULL,
  user_id = "me"
)
}
\arguments{
\item{mail}{mime mail message created by mime}

\item{type}{the type of upload to perform}

\item{thread_id}{the id of the thread to send from.}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}
}
\description{
Send a message from a mime message
}
\examples{
\dontrun{
gm_send_message(gm_mime(
  from = "you@me.com", to = "any@one.com",
  subject = "hello", "how are you doing?"
))
}
}
\references{
\url{https://developers.google.com/gmail/api/reference/rest/v1/users.messages/send}
}
\seealso{
Other message: 
\code{\link{gm_attachment}()},
\code{\link{gm_delete_message}()},
\code{\link{gm_import_message}()},
\code{\link{gm_insert_message}()},
\code{\link{gm_messages}()},
\code{\link{gm_message}()},
\code{\link{gm_modify_message}()},
\code{\link{gm_save_attachments}()},
\code{\link{gm_save_attachment}()},
\code{\link{gm_trash_message}()},
\code{\link{gm_untrash_message}()}
}
\concept{message}
