% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/err.R
\name{RMSLE}
\alias{RMSLE}
\title{Computes the Root Mean Squared Logged Error}
\usage{
RMSLE(model, adj, null = FALSE)
}
\arguments{
\item{model}{nrm model estimate}

\item{adj}{original adjacency matrix}

\item{null}{logical, whether to compute using null model}
}
\value{
numeric, root mean squared logged error of residuals of nrm model fit
}
\description{
Computes the Root Mean Squared Logged Error
}
\examples{

data('highschool.predictors')
highschool.m <- nrm(w=highschool.predictors[1], adj=contacts.adj, directed=FALSE, selfloops=FALSE)
RMSLE(highschool.m, contacts.adj)

}
