% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseg-package.R, R/ggseg.R
\docType{package}
\name{ggseg}
\alias{ggseg}
\alias{ggseg-package}
\title{ggseg: Plot brain segmentations with ggplot}
\usage{
ggseg(
  .data = NULL,
  atlas = "dk",
  position = "dispersed",
  view = NULL,
  hemisphere = NULL,
  adapt_scales = TRUE,
  ...
)
}
\arguments{
\item{.data}{A .data.frame to use for plot aesthetics. Should include a
column called "region" corresponding to aparc regions.}

\item{atlas}{Either a string with the name of atlas to use,
or a .data.frame containing atlas information (i.e. pre-loaded atlas).}

\item{position}{String choosing how to view the .data. Either "dispersed"[default] or "stacked".}

\item{view}{String to choose view of the .data. Any of c("lateral","medial")[default].}

\item{hemisphere}{String to choose hemisphere to plot. Any of c("left","right")[default].}

\item{adapt_scales}{if \code{TRUE}, then the axes will
be hemisphere without ticks.  If \code{FALSE}, then will be latitude
longitude values.  Also affected by \code{position} argument}

\item{...}{other options sent to geom_polygon for plotting, including
mapping aes (cannot include x, y, and group aesthetics).}
}
\value{
a ggplot object
}
\description{
Plotting results from analyses done on data derived from brain
segmentations is a common need, but may be quite laborious.
Results from such analyses are usually easier to interpret if
the plot can mimic the shape and position in the brain it
represents.

\code{ggseg} plots and returns a ggplot object of plotted
aparc regions. Is superseded by the new \code{\link{geom_brain}}.
}
\details{
This package contains data from various brain parcellations,
with convenient functions to inspect the results directly on
a brain-plot wither with ggplot (2D polygons).

\describe{

\item{`dk`}{
The Desikan-Killiany Cortical Atlas [default], FreeSurfer cortical segmentations.}

\item{`aseg`}{
FreeSurfer automatic subcortical segmentation of a brain volume}
}
}
\examples{
library(ggplot2)
ggseg()
ggseg(mapping=aes(fill=region))
ggseg(colour="black", size=.7, mapping=aes(fill=region)) + theme_void()
ggseg(position = "stacked")
ggseg(adapt_scales = FALSE)

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ggseg/ggseg}
  \item Report bugs at \url{https://github.com/ggseg/ggseg/issues}
}


[ggplot2][ggplot], [aes][aes],
[geom_polygon][geom_polygon], [coord_fixed][coord_fixed]
}
\author{
\strong{Maintainer}: Athanasia Mo Mowinckel \email{a.m.mowinckel@psykologi.uio.no} (\href{https://orcid.org/0000-0002-5756-0223}{ORCID})

Authors:
\itemize{
  \item Didac Vidal-Piñeiro \email{d.v.pineiro@psykologi.uio.no} (\href{https://orcid.org/0000-0001-9997-9156}{ORCID})
}


Athanasia Mo Mowinckel and Didac Vidal-Piñeiro
}
\keyword{internal}
