% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_soft_max_inplace}
\alias{ggml_soft_max_inplace}
\title{Softmax In-place (Graph)}
\usage{
ggml_soft_max_inplace(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor (will be modified in-place)}
}
\value{
View of input tensor with softmax applied
}
\description{
Creates a graph node for in-place softmax operation.
Returns a view of the input tensor.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 4)
ggml_set_f32(a, c(1, 2, 3, 4))
result <- ggml_soft_max_inplace(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
