% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_elu}
\alias{ggml_elu}
\title{ELU Activation (Graph)}
\usage{
ggml_elu(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the ELU operation
}
\description{
Creates a graph node for ELU (Exponential Linear Unit) activation.
ELU(x) = x if x > 0, else alpha * (exp(x) - 1) where alpha = 1.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(-2, -1, 0, 1, 2))
r <- ggml_elu(ctx, a)
graph <- ggml_build_forward_expand(ctx, r)
ggml_graph_compute(ctx, graph)
result <- ggml_get_f32(r)
ggml_free(ctx)
}
}
