% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheduler.R
\name{ggml_backend_sched_new}
\alias{ggml_backend_sched_new}
\title{Create a new backend scheduler}
\usage{
ggml_backend_sched_new(backends, parallel = TRUE, graph_size = 2048)
}
\arguments{
\item{backends}{List of backend pointers (from ggml_vulkan_init() or ggml_backend_cpu_init()).
Note: A CPU backend is automatically added, so you only need to specify GPU backends.}

\item{parallel}{Logical, whether to run backends in parallel (default: TRUE)}

\item{graph_size}{Expected maximum graph size (default: 2048)}
}
\value{
Scheduler pointer
}
\description{
Creates a scheduler that can distribute computation across multiple backends (GPUs, CPU).
A CPU backend is automatically added as a fallback. Backends with lower index have higher priority.
}
\examples{
\donttest{
if (ggml_vulkan_available() && ggml_vulkan_device_count() >= 2) {
  # Create two GPU backends (CPU is added automatically)
  gpu1 <- ggml_vulkan_init(0)
  gpu2 <- ggml_vulkan_init(1)

  # Create scheduler with both GPUs + CPU (automatic)
  sched <- ggml_backend_sched_new(list(gpu1, gpu2), parallel = TRUE)

  # The scheduler now has 3 backends: GPU1, GPU2, CPU
  cat("Backends:", ggml_backend_sched_get_n_backends(sched), "\\\\n")

  # Use scheduler...

  # Cleanup
  ggml_backend_sched_free(sched)
  ggml_vulkan_free(gpu1)
  ggml_vulkan_free(gpu2)
}
}
}
