% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quants.R
\name{dequantize_row_iq2_xxs}
\alias{dequantize_row_iq2_xxs}
\alias{dequantize_row_iq2_xs}
\alias{dequantize_row_iq2_s}
\alias{dequantize_row_iq3_xxs}
\alias{dequantize_row_iq3_s}
\alias{dequantize_row_iq4_nl}
\alias{dequantize_row_iq4_xs}
\alias{dequantize_row_iq1_s}
\alias{dequantize_row_iq1_m}
\title{Dequantize Row (IQ)}
\usage{
dequantize_row_iq2_xxs(raw_data, n_elements)

dequantize_row_iq2_xs(raw_data, n_elements)

dequantize_row_iq2_s(raw_data, n_elements)

dequantize_row_iq3_xxs(raw_data, n_elements)

dequantize_row_iq3_s(raw_data, n_elements)

dequantize_row_iq4_nl(raw_data, n_elements)

dequantize_row_iq4_xs(raw_data, n_elements)

dequantize_row_iq1_s(raw_data, n_elements)

dequantize_row_iq1_m(raw_data, n_elements)
}
\arguments{
\item{raw_data}{Raw vector containing quantized data}

\item{n_elements}{Number of elements to dequantize}
}
\value{
Numeric vector of dequantized values
}
\description{
Converts IQ (integer quantization) data back to float values.
IQ formats provide high compression with importance-matrix-aware quantization.
}
\seealso{
Other quantization: 
\code{\link{dequantize_row_mxfp4}()},
\code{\link{dequantize_row_q2_K}()},
\code{\link{dequantize_row_q4_0}()},
\code{\link{dequantize_row_tq1_0}()},
\code{\link{ggml_quant_block_info}()},
\code{\link{iq2xs_free_impl}()},
\code{\link{iq2xs_init_impl}()},
\code{\link{iq3xs_free_impl}()},
\code{\link{iq3xs_init_impl}()},
\code{\link{quantize_iq2_xxs}()},
\code{\link{quantize_mxfp4}()},
\code{\link{quantize_q2_K}()},
\code{\link{quantize_q4_0}()},
\code{\link{quantize_row_iq3_xxs_ref}()},
\code{\link{quantize_row_mxfp4_ref}()},
\code{\link{quantize_row_q2_K_ref}()},
\code{\link{quantize_row_q4_0_ref}()},
\code{\link{quantize_row_tq1_0_ref}()},
\code{\link{quantize_tq1_0}()}
}
\concept{quantization}
